package cn.smarthse.services.train.api.enums.question;


import cn.smarthse.util.common.StringUtils;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: TrainingApplyObject
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: < 培训 适用对象 >
 * @JDK version used:      <JDK1.8> 18
 * @since 2021/1/28-10:18
 */
public enum TrainingApplyObjectEnum {
    //1-主要负责人 2-职业卫生管理人员 3-劳动者
    LEADER("主要负责人",1, (byte)1),
    MANAGER ("职业卫生管理人员", 2, (byte)2),
    WORKER("劳动者", 3, (byte)3),

    ;

    // 成员变量
    private String name;
    private Integer code;
    private Byte value;
    // 构造方法

    private TrainingApplyObjectEnum(String name, Integer code, Byte value) {
        this.name = name;
        this.code = code;
        this.value = value;
    }
    // 普通方法
    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (TrainingApplyObjectEnum c : TrainingApplyObjectEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return null;
    }// 普通方法
    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (TrainingApplyObjectEnum c : TrainingApplyObjectEnum.values()) {
            if (c.getName().equals(name)) {
                return c.getCode();
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getCode() {
        return code;
    }
    public void setCode(Integer code) {
        this.code = code;
    }
	public Byte getValue() {
		return value;
	}
	public void setValue(Byte value) {
		this.value = value;
	}
}
