package cn.smarthse.services.train.api.enums.personal;

/**
 * 用户积分类型(1：挑战答题积分；2：每周答题积分；3：专项答题积分；4：视频学习积分；5：文章学习积分；6：分享积分；7：登入积分)
 * @Description 
 * @Author liaoly
 * @Date 2020年4月28日 上午9:42:08
 */
public enum UserIntegralTypeEnum {
	/**
	 * 挑战答题积分
	 */
	Integral_exam_challenge_1(1, 6, "挑战答题积分", "每次答对5道得3分，每次答对10道以上得6分，每日上限6分"),
	
	/**
	 * 每周答题积分
	 */
	Integral_exam_week_2(2, 5, "每周答题积分", "每周答题每答对1道得1分，每日上限5分"),
	
	/**
	 * 专项答题积分
	 */
	Integral_exam_special_3(3, 10, "专项答题积分", "每组答题每答对1道得1分，每日上限10分"),
	
	/**
	 * 视频学习积分
	 */
	learn_video_4(4, 6, "视频学习积分", "1分/有效观看视频累计3分钟，每日上限6分"),
	
	/**
	 * 文章学习积分
	 */
	learn_article_5(5, 6, "文章学习积分", "1分/有效阅读文章累计2分钟，每日上限6分"),
	
	/**
	 * 分享积分
	 */
	share_6(6, 2, "分享积分", "1分/分享1次，每日上限2分"),
	
	/**
	 * 登入积分
	 */
	login_7(7, 1, "登入积分", "1分/每日首次登录，每日上限1分"),
	
	/**
	 * 使用APP积分
	 */
	login_8(8, 1, "APP使用积分", "1分/每日首次打开APP，每日上限1分"),
	;

	private String name;

	private Integer value;
	
	private Integer valueMax;
	
	private String detail;

	private UserIntegralTypeEnum(Integer value, Integer valueMax, String name, String detail) {
		this.value = value;
		this.valueMax = valueMax;
		this.name = name;
		this.detail = detail;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}
	
	public Integer getValueMax() {
		return valueMax;
	}

	public void setValueMax(Integer valueMax) {
		this.valueMax = valueMax;
	}
	
	public static UserIntegralTypeEnum getByValue(Integer value) {
		for(UserIntegralTypeEnum questionTypeEnum : UserIntegralTypeEnum.values()){
			if(questionTypeEnum.getValue().equals(value) ){
				return questionTypeEnum;
			}
		}
		return null;
	}

	public static Integer getValue(String name) {
		for(UserIntegralTypeEnum questionTypeEnum : UserIntegralTypeEnum.values()){
			if(questionTypeEnum.getName().equals(name)){
				return questionTypeEnum.getValue();
			}
		}
		return null;
	}
	
	public static String getName(Integer value) {
		for(UserIntegralTypeEnum questionTypeEnum : UserIntegralTypeEnum.values()){
			if(questionTypeEnum.getValue().equals(value)){
				return questionTypeEnum.getName();
			}
		}
		return null;
	}
	
	public static Integer getValueMax(Integer value) {
		for(UserIntegralTypeEnum questionTypeEnum : UserIntegralTypeEnum.values()){
			if(questionTypeEnum.getValue().equals(value)){
				return questionTypeEnum.getValueMax();
			}
		}
		return null;
	}
}
