package cn.smarthse.services.train.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 培训类别（0-初训 1-复训）
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月29日 下午1:38:48
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TrainingTypeEnum {

	first_1("初训", (byte)0, "0"),
	
	again_2("复训", (byte)1, "1"),
	
	;
	
	private String name;
	
	private Byte type;

	private String value;

	private TrainingTypeEnum(String name, Byte type,  String value) {
		this.name = name;
		this.type = type;
		this.value = value;
	}
	
	public static String getName(Byte type) {
		
		if (type == null)  return null;
		
		for (TrainingTypeEnum c : values()) {
			if (c.getType().equals(type)) {
				return c.name;
			}
		}
		return null;
	}
			
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public Byte getType() {
		return type;
	}

	public void setType(Byte type) {
		this.type = type;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}