package cn.smarthse.services.train.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 培训考试类型（1-预考核 2-在线考试 3-线下考试）
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月29日 下午1:38:48
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TrainingExamTypeEnum {
	
	/**
	 * 预考核
	 */
	Training_Exam_Type_1("预考核", "1", 1),

	/**
	 * 在线考试
	 */
	Training_Exam_Type_2("在线考试", "2", 2),
	
	/**
	 * 线下考试
	 */
	Training_Exam_Type_3("线下考试", "3", 3),
	;

	private String name;

	private String value;

	private Integer type;

	private TrainingExamTypeEnum(String name, String value, Integer type) {
		this.name = name;
		this.value = value;
		this.type = type;
	}

	public static String getNameByValue(String value) {

		if (value == null)  return null;

		for (TrainingExamTypeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	public static TrainingExamTypeEnum getByType(Integer type) {

		if (type == null)  return null;

		for (TrainingExamTypeEnum c : values()) {
			if (c.getType().equals(type)) {
				return c;
			}
		}
		return null;
	}
	
	public static TrainingExamTypeEnum getByValue(String value) {

		if (value == null)  return null;

		for (TrainingExamTypeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c;
			}
		}
		return null;
	}

	public static String getName(Integer type) {

		if (type == null)  return null;

		for (TrainingExamTypeEnum c : values()) {
			if (c.getType().equals(type)) {
				return c.name;
			}
		}
		return null;
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
}