package cn.smarthse.services.train.api.enums;

import cn.smarthse.services.train.api.enums.question.TrainingApplyObjectEnum;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 培训考试规则类型 (主要是为了使用id和type字段)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月29日 下午1:38:48
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TrainingExamRuleEnum {

	Training_Exam_Type_1("主要负责人、职业卫生管理人员线下考试", 1L, 1),
	
	Training_Exam_Type_2("主要负责人、职业卫生管理人员在线预考核", 2L, 2),
	
	Training_Exam_Type_3("劳动者在线考试", 3L, 3),
	;
	
	private String name;
	
	private Long id;
	
	private Integer type;

	private TrainingExamRuleEnum(String name, Long id, Integer type) {
		this.name = name;
		this.id = id;
		this.type = type;
	}
	
	/**
	 * 根据role和考试类型 获取规则枚举
	 * @author liaoly
	 * @date 2021年2月5日 上午8:37:53
	 * @param role : 培训人员角色trainingMember.role
	 * @param examType : 考试类型
	 * @return TrainingExamRuleEnum
	 */
	public static TrainingExamRuleEnum getTrainingExamTypeEnum(Byte role, Integer examType) {
		TrainingExamTypeEnum examTypeEnum = TrainingExamTypeEnum.getByType(examType);
		return getTrainingExamTypeEnum(role, examTypeEnum);
	}
	
	/**
	 * 根据role和考试类型 获取规则枚举
	 * @author liaoly
	 * @date 2021年2月5日 上午8:37:53
	 * @param role : 培训人员角色trainingMember.role
	 * @param examType : 考试类型
	 * @return TrainingExamRuleEnum
	 */
	public static TrainingExamRuleEnum getTrainingExamTypeEnum(Byte role, String examType) {
		TrainingExamTypeEnum examTypeEnum = TrainingExamTypeEnum.getByValue(examType);
		return getTrainingExamTypeEnum(role, examTypeEnum);
	}
	/**
	 * 根据role和考试类型 获取规则枚举
	 * @author liaoly
	 * @date 2021年2月5日 上午8:37:53
	 * @param role : 培训人员角色trainingMember.role
	 * @param examTypeEnum : 考试类型枚举
	 * @return TrainingExamRuleEnum
	 */
	public static TrainingExamRuleEnum getTrainingExamTypeEnum(Byte role, TrainingExamTypeEnum examTypeEnum) {
		
		if (role == null || examTypeEnum == null) 
			return TrainingExamRuleEnum.Training_Exam_Type_1;
		if (role == TrainingApplyObjectEnum.LEADER.getValue()) { //主要负责人
			if (TrainingExamTypeEnum.Training_Exam_Type_1.equals(examTypeEnum)) { //预考核
				return TrainingExamRuleEnum.Training_Exam_Type_2; //
			} else if (TrainingExamTypeEnum.Training_Exam_Type_2.equals(examTypeEnum)) { //在线考试
				return TrainingExamRuleEnum.Training_Exam_Type_1;
			} else if (TrainingExamTypeEnum.Training_Exam_Type_3.equals(examTypeEnum)) { //线下考试
				return TrainingExamRuleEnum.Training_Exam_Type_1; //
			}
		} else if (role == TrainingApplyObjectEnum.MANAGER.getValue()) { //职业卫生管理人员
			if (TrainingExamTypeEnum.Training_Exam_Type_1.equals(examTypeEnum)) { //预考核
				return TrainingExamRuleEnum.Training_Exam_Type_2; //
			} else if (TrainingExamTypeEnum.Training_Exam_Type_2.equals(examTypeEnum)) { //在线考试
				return TrainingExamRuleEnum.Training_Exam_Type_1;
			} else if (TrainingExamTypeEnum.Training_Exam_Type_3.equals(examTypeEnum)) { //线下考试
				return TrainingExamRuleEnum.Training_Exam_Type_1; //
			}
		} else if (role == TrainingApplyObjectEnum.WORKER.getValue()) { //劳动者
			if (TrainingExamTypeEnum.Training_Exam_Type_1.equals(examTypeEnum)) { //预考核
				return TrainingExamRuleEnum.Training_Exam_Type_3; //
			} else if (TrainingExamTypeEnum.Training_Exam_Type_2.equals(examTypeEnum)) { //在线考试
				return TrainingExamRuleEnum.Training_Exam_Type_3; //
			} else if (TrainingExamTypeEnum.Training_Exam_Type_3.equals(examTypeEnum)) { //线下考试
				return TrainingExamRuleEnum.Training_Exam_Type_3; 
			}
		}
		return TrainingExamRuleEnum.Training_Exam_Type_1;
	}
	
	public static String getName(Long id) {
		
		if (id == null)  return null;
		
		for (TrainingExamRuleEnum c : values()) {
			if (c.getId().equals(id)) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getName(Integer type) {
		
		if (type == null)  return null;
		
		for (TrainingExamRuleEnum c : values()) {
			if (c.getType().equals(type)) {
				return c.name;
			}
		}
		return null;
	}
			
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
}