package cn.smarthse.services.train.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @program:
 * @description:
 * @author: yzp
 * @create: 2021/1/29 8:23
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TrainMemberRoleEnum {
	
	/**
	 * 主要负责人
	 */
    status1("主要负责人", 1, (byte)1),

    /**
	 * 职业卫生管理员
	 */
    status2("职业卫生管理员", 2, (byte)2),
    
    /**
	 * 劳动者
	 */
    status3("劳动者", 3, (byte)3),

    ;

    // 成员变量
    private String name;
    private Integer value;
    private Byte valueB;
    // 构造方法

    private TrainMemberRoleEnum(String name, Integer value, Byte valueB) {
        this.name = name;
        this.value = value;
        this.valueB = valueB;
    }
    // 普通方法
    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (TrainMemberRoleEnum c : TrainMemberRoleEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }
    
    public static String getName(Byte valueB) {
        if (valueB == null) {
            return null;
        }
        for (TrainMemberRoleEnum c : TrainMemberRoleEnum.values()) {
            if (c.getValueB().equals(valueB)) {
                return c.name;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getValue() {
        return value;
    }
    public void setValue(Integer index) {
        this.value = index;
    }
	public Byte getValueB() {
		return valueB;
	}
	public void setValueB(Byte valueB) {
		this.valueB = valueB;
	}
}
