package cn.smarthse.services.train.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 当前培训环节(1-培训课程学习; 2-在线预考核(管理者或者负责人)/在线考试(劳动者); 3-线下考试报名; 4-线下考试)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月5日 下午12:02:50
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SegmentEnum {
	
	/**
	 * 培训课程学习
	 */
    segment_1("培训课程学习", 1),

    /**
     * 在线预考核(管理者或者负责人)/在线考试(劳动者)
     */
    segment_2("在线预考核(管理者或者负责人)/在线考试(劳动者)", 2),
    
    /**
     * 线下考试报名
     */
    segment_3("在线预考核(管理者或者负责人)/在线考试(劳动者)", 3),
    
    /**
     * 线下考试
     */
    segment_4("线下考试", 4),

    ;

    private String name;
    private Integer value;
    
    private SegmentEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }
    // 普通方法
    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (SegmentEnum c : SegmentEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getValue() {
        return value;
    }
    public void setValue(Integer index) {
        this.value = index;
    }
}
