package cn.smarthse.services.train.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 精准培训环节编码(由app端编码的)
 * 1-1：表示劳动者，且没有培训课程没有完成的<br>
 * 1-2：表示劳动者，培训课程已完成，在线考试<br>
 * 1-3：表示劳动者，在线考试已通过，考试成绩<br>
 * 1-4：表示劳动者，在线考试未通过，在线考试，考试记录<br>
 * 2-1：表示管理者或者负责人，且没有培训课程没有完成的<br>
 * 2-2：表示管理者或者负责人，培训课程已完成，在线预考核<br>
 * 2-3：表示管理者或者负责人，在线预考核通过，线下报名考试<br>
 * 2-4：表示管理者或者负责人，在线预考核未通过，在线预考核，预考核记录<br>
 * 2-5：表示管理者或者负责人，线下考试已通过，考试成绩<br>
 * 2-6：表示管理者或者负责人，线下考试未通过，线下考试报名，考试记录<br>
 * 2-7：表示管理者或者负责人，已报名线下考试，报名考试地点信息内容
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月5日 下午12:02:50
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SegmentCodeEnum {
	
	/**
	 * 1-1：表示劳动者，且没有培训课程没有完成的
	 */
    segment_code_1_1("表示劳动者，且没有培训课程没有完成的", "1-1"),

    /**
     * 1-2：表示劳动者，培训课程已完成，在线考试
     */
    segment_code_1_2("表示劳动者，培训课程已完成，在线考试", "1-2"),
    
    /**
     * 1-3：表示劳动者，在线考试已通过，考试成绩
     */
    segment_code_1_3("表示劳动者，在线考试已通过，考试成绩", "1-3"),
    
    /**
     * 1-4：表示劳动者，在线考试未通过，在线考试，考试记录
     */
    segment_code_1_4("表示劳动者，在线考试未通过，在线考试，考试记录", "1-4"),
    
    /**
     * 2-1：表示管理者或者负责人，且没有培训课程没有完成的
     */
    segment_code_2_1("表示管理者或者负责人，且没有培训课程没有完成的", "2-1"),
    
    /**
     * 2-2：表示管理者或者负责人，培训课程已完成，在线预考核
     */
    segment_code_2_2("表示管理者或者负责人，培训课程已完成，在线预考核", "2-2"),
    
    /**
     * 2-3：表示管理者或者负责人，在线预考核通过，线下报名考试
     */
    segment_code_2_3("表示管理者或者负责人，在线预考核通过，线下报名考试", "2-3"),
    
    /**
     * 2-4：表示管理者或者负责人，在线预考核未通过，在线预考核，预考核记录
     */
    segment_code_2_4("表示管理者或者负责人，在线预考核未通过，在线预考核，预考核记录", "2-4"),
    
    /**
     * 2-5：表示管理者或者负责人，线下考试已通过，考试成绩
     */
    segment_code_2_5("表示管理者或者负责人，线下考试已通过，考试成绩", "2-5"),
    
    /**
     * 2-6：表示管理者或者负责人，线下考试未通过，线下考试报名，考试记录
     */
    segment_code_2_6("表示管理者或者负责人，线下考试未通过，线下考试报名，考试记录", "2-6"),
    
    /**
     * 2-7：表示管理者或者负责人，已报名线下考试，报名考试地点信息内容
     */
    segment_code_2_7("表示管理者或者负责人，已报名线下考试，报名考试地点信息内容", "2-7"),
    ;

    private String name;
    private String value;
    
    private SegmentCodeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }
    
    public static String getName(String value) {
        if (value == null) {
            return null;
        }
        for (SegmentCodeEnum c : SegmentCodeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }
}
