package cn.smarthse.services.train.api.enums;

/**
 * 试题类别(1：单选；2：多选；3：填空)
 * @Description 
 * @Author liaoly
 * @Date 2020年4月28日 上午9:42:08
 */
public enum QuestionTypeEnum {
	/**
	 * 单选
	 */
	radio_question(1, "单选题"),
	
	/**
	 * 多选
	 */
	checkbox_question(2, "多选题"),
	
	/**
	 * 填空
	 */
	fill_question(3, "填空题"),
	;

	private String name;

	private Integer value;

	private QuestionTypeEnum(Integer value, String name) {
		this.value = value;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public static QuestionTypeEnum getByValue(Integer value) {
		for(QuestionTypeEnum questionTypeEnum : QuestionTypeEnum.values()){
			if(questionTypeEnum.getValue().equals(value) ){
				return questionTypeEnum;
			}
		}
		return null;
	}

	public static Integer getQuestionTypeValue(String name) {
		for(QuestionTypeEnum questionTypeEnum : QuestionTypeEnum.values()){
			if(questionTypeEnum.getName().equals(name)){
				return questionTypeEnum.getValue();
			}
		}
		return null;
	}
}
