package cn.smarthse.services.train.api.enums;

/**
 * 试题类别(1：单选；2：多选；3：填空)
 * @Description 
 * @Author liaoly
 * @Date 2020年4月28日 上午9:42:08
 */
public enum QuestionStatusEnum {
	/**
	 * 未入库(草稿状态的试题)
	 */
	question_status_down_1(1, "未入库"),
	
	/**
	 * 已入库
	 */
	question_status_up_2(2, "已入库"),
	
	/**
	 * 已禁用(不需要的试题，或者过时的试题)
	 */
	question_status_forbidden_3(3, "已禁用"),
	;

	private String name;

	private Integer value;

	private QuestionStatusEnum(Integer value, String name) {
		this.value = value;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public static QuestionStatusEnum getByValue(Integer value) {
		for(QuestionStatusEnum questionTypeEnum : QuestionStatusEnum.values()){
			if(questionTypeEnum.getValue().equals(value) ){
				return questionTypeEnum;
			}
		}
		return null;
	}

	public static Integer getQuestionTypeValue(String name) {
		for(QuestionStatusEnum questionTypeEnum : QuestionStatusEnum.values()){
			if(questionTypeEnum.getName().equals(name)){
				return questionTypeEnum.getValue();
			}
		}
		return null;
	}
}
