package cn.smarthse.services.train.api.enums;

/**
 * 在线培训系统：类别
 * @Description 1:职业卫生综合; 2:职业危害防护; 3:职业健康监护; 4:职业危害因素; 5:职业卫生三同时; 6:职业病; 7:放射卫生;
 * @Author liaoly
 * @Date 2020年4月28日 上午9:42:08
 */
public enum PlatformTrainingTypeEnum {

	/**
	 * 职业卫生综合
	 */
	occupational_health_comprehensive_1(1, "职业卫生综合"),

	/**
	 * 职业危害防护
	 */
	occupational_hazards_protection_2(2, "职业危害防护"),

	/**
	 * 职业危害防护
	 */
	occupational_health_monitoring_3(3, "职业健康监护"),

	/**
	 * 职业危害因素
	 */
	occupational_hazard_factors_4(4, "职业危害因素"),

	/**
	 * 职业卫生三同时
	 */
	occupational_health_simultaneities_5(5, "职业卫生三同时"),

	/**
	 * 职业病
	 */
	occupational_diseases_6(6, "职业病"),

	/**
	 * 放射卫生
	 */
	radiation_hygiene_7(7, "放射卫生"),
	;

	private String name;

	private Integer value;

	private PlatformTrainingTypeEnum(Integer value, String name) {
		this.value = value;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public static PlatformTrainingTypeEnum getByValue(Integer value) {
		for(PlatformTrainingTypeEnum questionTypeEnum : PlatformTrainingTypeEnum.values()){
			if(questionTypeEnum.getValue().equals(value) ){
				return questionTypeEnum;
			}
		}
		return null;
	}

	public static Integer getQuestionTypeValue(String name) {
		for(PlatformTrainingTypeEnum questionTypeEnum : PlatformTrainingTypeEnum.values()){
			if(questionTypeEnum.getName().equals(name)){
				return questionTypeEnum.getValue();
			}
		}
		return null;
	}
}
