package cn.smarthse.services.train.api.enums;

/**
 * 每周/专项答题状态状态(1：未上架；2：已上架；3：已结束)
 * @Description 
 * @Author xiaoyi
 * @Date 2020年4月28日 上午9:42:08
 */
public enum ExamStatusEnum {
	/**
	 * 未上架
	 */
	status_down_1(1, "未上架"),
	
	/**
	 * 已上架
	 */
	status_up_2(2, "已上架"),
	
	/**
	 * 已结束
	 */
	status_end_3(3, "已结束"),
	;

	private String name;

	private Integer value;

	private ExamStatusEnum(Integer value, String name) {
		this.value = value;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public static ExamStatusEnum getByValue(Integer value) {
		for(ExamStatusEnum questionTypeEnum : ExamStatusEnum.values()){
			if(questionTypeEnum.getValue().equals(value) ){
				return questionTypeEnum;
			}
		}
		return null;
	}

	public static Integer getValue(String name) {
		for(ExamStatusEnum questionTypeEnum : ExamStatusEnum.values()){
			if(questionTypeEnum.getName().equals(name)){
				return questionTypeEnum.getValue();
			}
		}
		return null;
	}
}
