package cn.smarthse.services.train.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 考试状态(0：未考试；1：已考试,合格；2：已考试,不合格)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月5日 下午12:02:50
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ExamStateEnum {
	
	/**
	 * 未考试
	 */
    status0("未考试",0, "0"),

    /**
     * 已考试,合格
     */
    status1("已考试,合格",1, "1"),
    
    /**
     * 已考试,不合格
     */
    status2("已考试,不合格",2, "2"),

    ;

    // 成员变量
    private String name;
    private Integer value;
    private String type;
    // 构造方法

    private ExamStateEnum(String name, Integer value, String type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }
    // 普通方法
    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (ExamStateEnum c : ExamStateEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getValue() {
        return value;
    }
    public void setValue(Integer index) {
        this.value = index;
    }
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
}
