package cn.smarthse.services.train.api.enums;

/**
 * 文章状态(1：草稿；2：已上架；3：已下架)
 * @Description 
 * @Author liaoly
 * @Date 2020年4月28日 上午9:42:08
 */
public enum ArticleStatusEnum {
	/**
	 * 草稿
	 */
	article_status_draft_1(1, "草稿"),
	
	/**
	 * 已上架
	 */
	article_status_up_2(2, "已上架"),
	
	/**
	 * 已下架
	 */
	article_status_down_3(3, "已下架"),
	;

	private String name;

	private Integer value;

	private ArticleStatusEnum(Integer value, String name) {
		this.value = value;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public static ArticleStatusEnum getByValue(Integer value) {
		for(ArticleStatusEnum questionTypeEnum : ArticleStatusEnum.values()){
			if(questionTypeEnum.getValue().equals(value) ){
				return questionTypeEnum;
			}
		}
		return null;
	}

	public static Integer getArticleStatus(String name) {
		for(ArticleStatusEnum questionTypeEnum : ArticleStatusEnum.values()){
			if(questionTypeEnum.getName().equals(name)){
				return questionTypeEnum.getValue();
			}
		}
		return null;
	}
}
