package cn.smarthse.services.train.api.entity.video;


import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2021-01-27 04:11
 */
@Data
@ApiModel(value = "TrainingVideoMember", description = "用户-视频关系表(用户需要学习的视频)")
public class TrainingVideoMember extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "ID")
    private Long id;
    /**
     * 视频id
     */
	@ApiModelProperty(value = "视频id")
    private Long videoId;
    /**
     * 培训id
     */
    @ApiModelProperty(value = "培训id")
    private Long trainId;
    /**
     * 培训参与者id，在线培训对应staffId
     */
	@ApiModelProperty(value = "用户id")
    private Long memberId;
    /**
     * 视频学习状态(0,未学习; 1,学习中; 2,已学习)
     */
	@ApiModelProperty(value = "视频学习状态(0,未学习; 1,学习中; 2,已学习)")
    private Integer status;
    /**
     * 已学习时长(单位为秒)
     */
	@ApiModelProperty(value = "已学习时长(单位为秒)")
    private Long learnTime;
    /**
     * 是否有效(1：有效；0：无效)
     */
    private Boolean isValid;

    @TableField(exist = false)
    @ApiModelProperty(value = "视频课程名称")
    private String videoName;


}
