package cn.smarthse.services.train.api.entity.video;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 培训视频
 * </p>
 *
 * @author xubin
 * @since 2021-01-25
 */
@Data
@ApiModel(value="TrainingVideo对象", description="培训视频")
public class TrainingVideo extends BaseEntity {

    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "有效区域")
    private Long areaId;

    @ApiModelProperty(value = "视频名称")
    private String name;
    /**
    *db_platform_training.video.minutes
    */
    @ApiModelProperty(value = "视频时长")
    private Long videoTime;

    @ApiModelProperty(value = "对应学时")
    private BigDecimal learnHour;
    /**
     *db_platform_training.video.source
     */
    @ApiModelProperty(value = "视频来源")
    private String videoFrom;

    @ApiModelProperty(value = "培训讲师")
    private String trainingTeacher;
    /**
     *db_platform_training.video.screenshot(视频截图sys_file.id)
     */
    @ApiModelProperty(value = "视频画面")
    private Long videoImgage;
    @ApiModelProperty(value = "视频画面")
    private String videoImageUrl;
    
    @ApiModelProperty(value = "视频文件")
    private Long videoFile;
    /**
     *db_platform_training.video.url
     */
    @ApiModelProperty(value = "视频文件")
    private String videoFileUrl;

    /**
     *db_platform_training.video.description
     */
    @ApiModelProperty(value = "视频简介")
    private String videoDescription;

    @ApiModelProperty(value = "腾讯视频vid")
    private String vid;
    /**
     *db_platform_training.video.status 状态(1:草稿；2:上架; 3:下架)
     */
    @ApiModelProperty(value = "状态，  1未上架  2已上架 3 已下架")
    private Integer state;
    /**
     *db_platform_training.video.shelves_time
     */
    @ApiModelProperty(value = "上架时间")
    private LocalDateTime onShelvesTime;

    @ApiModelProperty(value = "下架时间")
    private LocalDateTime offShelvesTime;

    @ApiModelProperty(value = "数据来源:1:监管端 2:运维端 3:企业端 4:平台")
    private Integer dataSource;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "视频类别见cn.smarthse.modules.platform.training.enums.TrainingTypeEnum（1:职业卫生综合; 2:职业危害防护; 3:职业健康监护; 4:职业危害因素; 5:职业卫生三同时; 6:职业病; 7:放射卫生;）")
    private Integer type;

    @ApiModelProperty(value = "腾讯视频url")
    private String txUrl;


    @ApiModelProperty(value = "视频大小/B")
    private String size;

    @ApiModelProperty(value = "编制人")
    private String compiler;


}
