package cn.smarthse.services.train.api.entity.question;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * @Title: TrainingQuestion
 * @Project:  ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 47
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2021/1/26-22:47
 */
/**
    * 培训试题
    */
@Data
@TableName(value = "training_question")
public class TrainingQuestion extends BaseEntity implements Serializable {

    /**
     * 有效区域
     */
    @TableField(value = "area_id")
    private Long areaId;
    /**
     * 企业id
     */
    @TableField(value = "cid")
    private Long cid;

    /**
     * 题干
     */
    @TableField(value = "title")
    private String title;

    /**
     * 使用类别（1、练习题 2、考试题， 逗号分割）
     */
    @TableField(value = "use_type")
    private String useType;
    /**
     * 条目(1:职业卫生综合; 2:职业危害防护; 3:职业健康监护; 4:职业危害因素; 5:职业卫生三同时; 6:职业病; 7:放射卫生;)
     */
    @TableField(value = "type")
    private Integer type;
    /**
     * 试题类别（1、单选 2、多选 3、填空）
     */
    @TableField(value = "question_type")
    private Integer questionType;
    /**
     * 适用对象（1-主要负责人 2-职业卫生管理人员 3-劳动者）多个逗号分割
     */
    @TableField(value = "apply_object")
    private String applyObject;
    /**
     * 正确答案
     */
    @TableField(value = "correct_answer")
    private String correctAnswer;

    /**
     * 解析
     */
    @TableField(value = "analysis")
    private String analysis;

    /**
     * 状态，  1已入库  2已禁用
     */
    @TableField(value = "`state`")
    private Integer state;

    /**
     * 数据来源:1:监管端 2:运维端 3:企业端
     */
    @TableField(value = "`data_source`")
    private Integer dataSource;

    /**
     * 权值(成为当前测试试题的概率)
     */
    @TableField(value = "`weight`")
    private Integer weight;


    /**
     * 题目分数
     */
    @TableField(value = "`score`")
    private Integer score;



    private static final long serialVersionUID = 1L;
}