package cn.smarthse.services.train.api.entity.personal;

import cn.smarthse.db.common.entity.BaseEntity;
import lombok.Data;

/**
 * 用户积分流水记录
 * @Description 
 * @Author liaoly
 * @Date 2020年4月26日 下午4:11:39
 */
public @Data
class UserIntegralLog extends BaseEntity {
	private static final long serialVersionUID = 1L;
	/**
	 *
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
	private Long id;
	 */
	/**
	 * 用户账号id
	 */
	private Long userId;
	/**
	 * 本次积分类型(1：挑战答题积分；2：每周答题积分；3：专项答题积分；4：视频学习积分；5：文章学习积分；6：分享积分；7：登入积分；8：APP使用积分)
	 */
	private Integer type;
	/**
	 * 本次积分流水-积分数(有正负，负数代表扣除)
	 */
	private Integer integral;
	/**
	 * 积分产生的业务数据id(可能没有)
	 */
	private Long businessId;
	/**
	 * 创建时间
	 */
	//private Date createDate;
	/**
	 * 最后修改时间
	 */
	//private Date updateDate;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
	//private Boolean isValid;
}
