package cn.smarthse.services.train.api.entity.exam;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 培训考试参与人表
 * </p>
 *
 * @author yangzp
 * @since 2021-01-21
 */
@Data
@ApiModel(value="TraningExamTimeMember对象", description="培训考试参与人表")
public class TrainingExamTimeMember extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "参与人id")
    private Long memberId;

    @ApiModelProperty(value = "考试时间id")
    private Long timeId;

    /**
     * 创建人
     */
    private Long id;

    private Boolean isValid;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 创建时间
     */
    private LocalDateTime createDate;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 更新时间
     */
    private LocalDateTime updateDate;
}
