package cn.smarthse.services.train.api.entity.exam;


import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 培训考试时间
 * </p>
 *
 * @author haosw
 * @since 2021-01-25
 */
@Data
@ApiModel(value="TraningExamTime对象", description="培训考试时间")
public class TrainingExamTime extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "考试结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "考试地点")
    private String address;

    @ApiModelProperty(value = "满额人数")
    private Integer total;

    @ApiModelProperty(value = "考试开始时间")
    private LocalDateTime beginTime;
}
