package cn.smarthse.services.train.api.entity.exam;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * 培训考试试题规则详情
 * </p>
 *
 * @author haosw
 * @since 2021-01-22
 */
@Data
@ApiModel(value="TraningExamRuleDetail对象", description="培训考试试题规则详情")
public class TrainingExamRuleDetail extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "规则id")
    private Long ruleId;

    @ApiModelProperty(value = "考试题型（1.单选 2.多选 3.填空）")
    private String questionType;

    @ApiModelProperty(value = "数量")
    private Integer num;

    @ApiModelProperty(value = "每题分数")
    private Integer eachScore;
}
