package cn.smarthse.services.train.api.entity.exam;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 培训考试试题规则
 * </p>
 *
 * @author haosw
 * @since 2021-01-22
 */
@Data
@ApiModel(value="TraningExamRule对象", description="培训考试试题规则")
public class TrainingExamRule extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "适用区域")
    private Long areaId;

    @ApiModelProperty(value = "考试类型id")
    private Long examTypeId;

    @ApiModelProperty(value = "考核题目")
    private String assessTopic;

    @ApiModelProperty(value = "考核时间")
    private Integer assessTime;

    @ApiModelProperty(value = "合格分数")
    private Integer passScore;

    private Long cid;

    //数据来源:1:监管端 2:运维端 3:企业端
    private Integer dataSource;
}
