package cn.smarthse.services.train.api.entity.challenganswer;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;


/**
 * 用户测试结果表
 * @Description
 * @Author xiaoyi
 * @Date 2022/5/26 下午4:06:45
 */
@TableName(value = "user_exam_question")
public @Data class UserExamQuestion extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 1L;

	/**
	 * 用户账号id
	 */
	@TableField(value = "user_id")
	private Long userId;
	/**
	 * 试卷id(来自exam.id或者exam_challenge.id)
	 */
	@TableField(value = "exam_id")
	private Long examId;
	/**
	 * 试题id
	 */
	@TableField(value = "question_id")
	private Long questionId;
	/**
	 * 选择题作答结果
	 */
	@TableField(value = "answer")
	private String answer;
	/**
	 * 填空题作答结果
	 */
	@TableField(value = "fill_answer")
	private String fillAnswer;
	/**
	 * 状态(1：草稿 2：已提交)
	 */
	@TableField(value = "status")
	private Integer status;
	/**
	 * 结果判定(对：true；错：false)
	 */
	@TableField(value = "result")
	private Boolean result;
	/**
	 * 本题得分
	 */
	@TableField(value = "score")
	private Integer score;

}
