package cn.smarthse.services.train.api.entity.challenganswer;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 用户-测试表
 * @Description
 * @Author xiaoyi
 * @Date 2022/5/26 下午4:06:45
 */
@TableName(value = "user_exam")
public @Data class UserExam extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 1L;

    /**
	 * user表id
	 */
	@TableField(value = "user_id")
	private Long userId;
	/**
	 * 测试表id
	 */
	@TableField(value = "exam_id")
	private Long examId;
	/**
	 * 开始作答时间
	 */
	@TableField(value = "begin_time")
	private Date beginTime;
	/**
	 * 结束作答时间
	 */
	@TableField(value = "end_time")
	private Date endTime;
	/**
	 * 连续答对试题数量
	 */
	@TableField(value = "series_right_num")
	private Integer seriesRightNum;
	/**
	 * 得分(所有答对的question.score和)
	 */
	@TableField(value = "total_score")
	private Integer totalScore;
	/**
	 * 挑战答题得分(有积分规则，不一定等于total_score)
	 */
	@TableField(value = "challenge_total_score")
	private Integer challengeTotalScore;



}
