package cn.smarthse.services.train.api.entity.challenganswer;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 挑战答题-试题
		 * @Description
 * @Author xiaoyi
		* @Date 2022/5/26 下午4:06:45
 */
@TableName(value = "exam_challenge")
public @Data class ExamChallenge extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 1L;

	/**
	 * 挑战答题名(默认userId+时间)
	 */
	@TableField(value = "name")
	private String name;
	/**
	 * 总分
	 */
	@TableField(value = "total_score")
	private Integer totalScore;

	
	/**
	 * 得到当前周的试卷名
	 */
	public String getExamName() {
		
		Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy年MM月dd日试题");
        
        return format.format(now);
	}
}
