package cn.smarthse.services.train.api.entity.challenganswer;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 测试表(程序生成)
 * @Description 
 * @Author xiaoyi
 * @Date 2022/5/26 下午4:06:45
 */
@Data
@TableName(value = "exam")
public class Exam extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 1L;

	/**
	 * 测试卷名称
	 */
	@TableField(value = "name")
	private String name;
	/**
	 * 状态(1：未上架；2：已上架)
	 */
	@TableField(value = "status")
	private Integer status;
	/**
	 * 是否专项答题试卷(专项: true; 不是专项: false)
	 */
	@TableField(value = "is_special")
	private Boolean isSpecial;
	/**
	 * 总分(每个题目的分数和)
	 */
	@TableField(value = "total_score")
	private Integer totalScore;
	/**
     * 答题人数
     */
	@TableField(value = "total_user")
    private Integer totalUser;
    /**
	 * 上架时间
	 */
	@TableField(value = "shelves_time")
	private Date shelvesTime;

	/**
	 * 得到当前周的试卷名
	 */
	public String getExamName() {
		
		Calendar calendar = Calendar.getInstance();
		calendar.setFirstDayOfWeek(Calendar.MONDAY);//周一为第一天
		int weekOfMonth = calendar.get(Calendar.WEEK_OF_MONTH);//得到是当月的第几周
		
		SimpleDateFormat format = new SimpleDateFormat("yyyy年MM月");
        
		//eg: 2020年04月第5周答题
        return format.format(calendar.getTime()) + "第" + weekOfMonth + "周答题";
	}
	
	/**
	 * 得到下周的试卷名
	 */
	public String getNextWeekExamName() {
		
		//2020-04-30执行
		Calendar calendar = Calendar.getInstance();
		calendar.setFirstDayOfWeek(Calendar.MONDAY);//周一为第一天
		calendar.add(Calendar.DAY_OF_MONTH, 7);//加7天(下周)
		
		int weekOfMonth = calendar.get(Calendar.WEEK_OF_MONTH);//得到是当月的第几周
		
		SimpleDateFormat format = new SimpleDateFormat("yyyy年MM月");
        
		//eg: 2020年05月第1周答题
        return format.format(calendar.getTime()) + "第" + weekOfMonth + "周答题";
	}
}
