package cn.smarthse.services.train.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 培训人员表
 * </p>
 *
 * @author yangzp
 * @since 2021-01-21
 */
@Data
@ApiModel(value="TraningMember对象", description="培训人员表")
public class TrainingMember extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "角色(1:主要负责人 2:职业卫生管理人员 3:劳动者)")
    private Byte role;

    @ApiModelProperty(value = "人员id")
    private Long staffId;

    @ApiModelProperty(value = "人员姓名")
    private String staffName;

    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "行业分类")
    private Long industryCategory;

    @ApiModelProperty(value = "区域id")
    private Long areaId;

    @ApiModelProperty(value = "性别(0:女 1:男)")
    private Byte gender;

    @ApiModelProperty(value = "岗位/工种id")
    private Long staffWorkId;

    @ApiModelProperty(value = "岗位/工种名称")
    private String staffWorkName;

    @ApiModelProperty(value = "身份证号")
    private String idcard;

    @ApiModelProperty(value = "手机号码")
    private String mobile;

    @ApiModelProperty(value = "培训类别（0-初训 1-复训）")
    private Byte trainingType;

    @ApiModelProperty(value = "培训年度")
    private Integer trainingYear;

    @ApiModelProperty(value = "要求培训学时")
    private BigDecimal requireHour;

    @ApiModelProperty(value = "已培训学时")
    private BigDecimal trainedHour;

    @ApiModelProperty(value = "预考核状态")
    private Byte testExamState;

    @ApiModelProperty(value = "预考核时间")
    private LocalDateTime testExamTime;

    @ApiModelProperty(value = "考试状态（0-未考试 1-已考试，合格 2-已考试，不合格）")
    private Byte examState;

    @ApiModelProperty(value = "考试时间")
    private LocalDateTime examTime;

    @ApiModelProperty(value = "是否有效")
    private Boolean isValid;

    @ApiModelProperty(value = "创建人")
    private Long createBy;

    @ApiModelProperty(value = "创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "修改人")
    private Long updateBy;

    @ApiModelProperty(value = "修改日期")
    private LocalDateTime updateDate;


}
