package cn.smarthse.dy.vo.offlineTraining;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@Data
public class OfflineTrainingStaffListVo implements Serializable {

    /**
     * ID
     */
    private Long id;

    /**
     * 人员姓名
     */
    private String name;

    /**
     * 身份证
     */
    private String idCard;

    /**
     * 手机号
     */
    private String tel;

    /**
     * 单位id
     */
    private Long cid;

    /**
     * 单位名称（冗余）
     */
    private String companyName;

    /**
     * 人员类型，CertificateStaffNameTypeEnum
     */
    private Long trainPersonnelType;
    private String trainPersonnelTypeStr;

    /**
     * 签到时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date signInTime;

    /**
     * 签退时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date signOutTime;

    private Long fileId;

    private SysFileModel sysFileModel;

    public String getTrainPersonnelTypeStr() {

        return Objects.isNull(trainPersonnelType) ? "-" : CertificateStaffNameTypeEnum.getNameTypeById(trainPersonnelType);
    }

}
