package cn.smarthse.dy.vo.offlineTraining;

import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

@Data
public class OfflineTrainingQrListVo implements Serializable {

    /**
     * ID
     */
    private Long id;
    private String ids;

    /**
     * 单位id
     */
    private Long cid;

    /**
     * 单位名称（冗余）
     */
    private String companyName;

    /**
     * 培训人员类型（英文逗号分割），CertificateStaffNameTypeEnum
     */
    private String trainPersonnelType;
    private String trainPersonnelTypeStr;

    public String getTrainPersonnelTypeStr() {

        return Objects.isNull(trainPersonnelType) ? "-" : CertificateStaffNameTypeEnum.getNameTypesByIds(trainPersonnelType);
    }

}
