package cn.smarthse.dy.vo.offlineTraining;

import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainProfileStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@Data
public class OfflineTrainingProjListVo implements Serializable {

    /**
     * ID
     */
    private Long id;

    /**
     * 培训项目名称
     */
    private String trainProjName;

    /**
     * 培训人员类型（英文逗号分割），CertificateStaffNameTypeEnum
     */
    private String trainPersonnelType;
    private String trainPersonnelTypeStr;

    /**
     * 签到人数
     */
    private Long signInNums = 0L;

    /**
     * 签退人数
     */
    private Long signOutNums = 0L;

    /**
     * 未签退人数
     */
    private Long noSignOutNums = 0L;

    /**
     * 完成取证人数
     */
    private Long completeEvidenceNums = 0L;

    /**
     * 签到二维码
     */
    private String signInQrCode;

    /**
     * 签退二维码
     */
    private String signOutQrCode;

    /**
     * 培训档案状态，TrainProfileStatusEnum
     */
    private Byte trainProfileStatus;
    private String trainProfileStatusStr;

    /**
     * 培训开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date trainBeginDate;

    /**
     * 培训结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date trainEndDate;

    public String getTrainPersonnelTypeStr() {

        return Objects.isNull(trainPersonnelType) ? "-" : CertificateStaffNameTypeEnum.getNameTypesByIds(trainPersonnelType);
    }

    public String getTrainProfileStatusStr() {

        return Objects.isNull(trainProfileStatus) ? "-" : TrainProfileStatusEnum.getNameByValue(trainProfileStatus);
    }
}
