package cn.smarthse.dy.vo.offlineTraining;

import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@Data
public class OfflineTrainingCertificateVo implements Serializable {

    /**
     * ID
     */
    private Long id;

    /**
     * 人员姓名
     */
    private String name;

    /**
     * 身份证
     */
    private String idCard;

    /**
     * 人员类型，CertificateStaffNameTypeEnum
     */
    private Long trainPersonnelType;
    private String trainPersonnelTypeStr;

    /**
     * 签退时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date signOutTime;

    /**
     * 培训发布单位
     */
    private String trainPublishUnit;

    /**
     * 证书编号
     */
    private String certificateNo;

    private Long cid;

    private Boolean isHasCertificate;

    private Boolean isStore;

    public String getTrainPersonnelTypeStr() {

        return Objects.isNull(trainPersonnelType) ? "-" : CertificateStaffNameTypeEnum.getNameTypeById(trainPersonnelType);
    }

}
