package cn.smarthse.dy.provider;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.dy.dto.offlineTraining.OfflineTrainingProjAddParam;
import cn.smarthse.dy.dto.offlineTraining.OfflineTrainingProjEditParam;
import cn.smarthse.dy.dto.offlineTraining.OfflineTrainingProjListParam;
import cn.smarthse.dy.dto.offlineTraining.OfflineTrainingStaffListParam;
import cn.smarthse.dy.vo.offlineTraining.OfflineTrainingProjListVo;
import cn.smarthse.dy.vo.offlineTraining.OfflineTrainingProjOneVo;
import cn.smarthse.dy.vo.offlineTraining.OfflineTrainingStaffListVo;

import java.util.List;

public interface IOfflineTrainingProviderService {

    JqGridData<OfflineTrainingProjListVo> getOfflineTrainingProjList(OfflineTrainingProjListParam param);

    OfflineTrainingProjOneVo getOfflineTrainingProjOne(Long id);

    /**
     * 新增
     *
     * @param param
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2024/6/18 上午9:18
     */
    Boolean saveOfflineTrainingProj(OfflineTrainingProjAddParam param);

    /**
     * 更新
     *
     * @param param
     * @return {@link boolean}
     * @author ShenZQ
     * @since 2024/6/18 上午10:58
     */
    Boolean updateOfflineTrainingProj(OfflineTrainingProjEditParam param);

    /**
     * 删除
     *
     * @param idList
     * @param loginUserId
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2024/6/18 上午11:00
     */
    Boolean deleteOfflineTrainingProj(List<Long> idList, Long loginUserId);

    JqGridData<OfflineTrainingStaffListVo> getOfflineTrainingStaffList(OfflineTrainingStaffListParam param);

    /**
     * 删除
     *
     * @param idList
     * @param loginUserId
     * @return {@link boolean}
     * @author ShenZQ
     * @since 2024/6/19 上午10:24
     */
    boolean deleteOfflineTrainingStaff(List<Long> idList, Long loginUserId);

}
