package cn.smarthse.dy.provider;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.dy.dto.PersonnelListParam;
import cn.smarthse.dy.dto.home.DyHomePersonnelParam;
import cn.smarthse.dy.entity.DyOrganizationUser;
import cn.smarthse.dy.vo.PersonnelListVo;
import cn.smarthse.dy.vo.home.DyHomePersonnelDetailVo;

public interface IDyOrganizationUserProviderService {

    JqGridData<PersonnelListVo> getList(PersonnelListParam param);

    Integer getHomePersonnelNums(DyHomePersonnelParam param);

    /**
     * 人均巡查企业数
     * @param param
     * @return {@link String}
     * @author chuhy
     * @date 2024/5/28 10:15
     */
    String getHomePersonData2(DyHomePersonnelParam param);

    DyOrganizationUser getOneByDataSourceId(String dataSourceId);

    /**
     * 首页可视化 - 查询人员巡查次数
     * @param param
     * @return {@link DyHomePersonnelDetailVo}
     * @author chuhy
     * @date 2024/5/14 10:48
     */
    JqGridData<DyHomePersonnelDetailVo> listPersonPatrolNum(DyHomePersonnelParam param);
}
