package cn.smarthse.dy.provider;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.dy.dto.DyCompanyAddParam;
import cn.smarthse.dy.dto.offlineTraining.OfflineTrainingCompanyEditParam;
import cn.smarthse.dy.dto.offlineTraining.OfflineTrainingCompanyListParam;
import cn.smarthse.dy.vo.offlineTraining.OfflineTrainingCompanyListVo;
import cn.smarthse.dy.vo.offlineTraining.OfflineTrainingCompanyOneVo;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;

import java.util.List;

public interface IDyCompanyProviderService {

    boolean save(DyCompanyAddParam param);

    boolean deleteById(Long id);

    /**
     * 判断企业名称是否已存在
     */
    Boolean isHaveThisName(String name, Long excludeId);

    JqGridData<OfflineTrainingCompanyListVo> getList(OfflineTrainingCompanyListParam param);

    JqGridData<CompanySuperviseModel> getQRCompanyList(CompanySuperviseSearchModel companySearchVo, int pageNum, int pageSize);

    OfflineTrainingCompanyOneVo getOne(Long id);

    boolean update(OfflineTrainingCompanyEditParam param);

    void updateIsStoreSet0(List<Long> cidList);

}
