package cn.smarthse.dy.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 线下培训人员档案
 *
 * @TableName offline_training_staff
 */
@TableName(value = "offline_training_staff")
@Data
public class OfflineTrainingStaff implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 培训项目id
     */
    @TableField(value = "train_proj_id")
    private Long trainProjId;

    /**
     * 人员姓名
     */
    @TableField(value = "name")
    private String name;

    /**
     * 身份证
     */
    @TableField(value = "id_card")
    private String idCard;

    /**
     * 手机号
     */
    @TableField(value = "tel")
    private String tel;

    /**
     * 单位id
     */
    @TableField(value = "cid")
    private Long cid;

    /**
     * 单位名称（冗余）
     */
    @TableField(value = "company_name")
    private String companyName;

    /**
     * 行政区划
     */
    @TableField(value = "area_id")
    private Long areaId;

    /**
     * 人员类型，CertificateStaffNameTypeEnum
     */
    @TableField(value = "train_personnel_type")
    private Long trainPersonnelType;

    /**
     * 年份
     */
    @TableField(value = "year")
    private Integer year;

    /**
     * 流水号
     */
    @TableField(value = "serial_no")
    private Integer serialNo;

    /**
     * 证书编号（6位区位码+2位证书类型码（CertificateStaffNameTypeEnum）+2位年份码+6位流水号）
     */
    @TableField(value = "certificate_no")
    private String certificateNo;

    @TableField(value = "file_id")
    private Long fileId;

    /**
     * 签到时间
     */
    @TableField(value = "sign_in_time")
    private Date signInTime;

    /**
     * 签退时间
     */
    @TableField(value = "sign_out_time")
    private Date signOutTime;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 创建人ID
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}