package cn.smarthse.dy.entity;

import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 线下培训项目档案
 *
 * @TableName offline_training_proj
 */
@TableName(value = "offline_training_proj")
@Data
public class OfflineTrainingProj implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 培训项目名称
     */
    @TableField(value = "train_proj_name")
    private String trainProjName;

    /**
     * 培训开始时间
     */
    @TableField(value = "train_begin_date")
    private Date trainBeginDate;

    /**
     * 培训结束时间
     */
    @TableField(value = "train_end_date")
    private Date trainEndDate;

    /**
     * 培训人员类型（英文逗号分割），CertificateStaffNameTypeEnum
     */
    @TableField(value = "train_personnel_type")
    private String trainPersonnelType;
    @TableField(exist = false)
    private Map<Long, String> trainPersonnelTypeMap;

    /**
     * 培训内容
     */
    @TableField(value = "train_content")
    private String trainContent;

    /**
     * 培训区域id
     */
    @TableField(value = "train_area_id")
    private Long trainAreaId;

    /**
     * 培训档案状态，TrainProfileStatusEnum
     */
    @TableField(value = "train_profile_status")
    private Byte trainProfileStatus;

    /**
     * 培训发布单位ID
     */
    @TableField(value = "train_publish_unit_id")
    private Long trainPublishUnitId;

    /**
     * 培训发布单位
     */
    @TableField(value = "train_publish_unit")
    private String trainPublishUnit;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 创建人ID
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    public Map<Long, String> getTrainPersonnelTypeMap() {
        if (StrUtil.isBlank(this.trainPersonnelType)) {
            return Collections.emptyMap();
        }

        return buildTrainPersonnelTypeMap(this.trainPersonnelType);
    }

    private Map<Long, String> buildTrainPersonnelTypeMap(String trainPersonnelType) {
        return Arrays.stream(trainPersonnelType.split(","))
                .filter(StrUtil::isNotBlank)
                .mapToLong(s -> {
                    try {
                        return Long.parseLong(s);
                    } catch (NumberFormatException e) {
                        return -1;
                    }
                })
                .boxed()
                .collect(Collectors.toMap(i -> i, CertificateStaffNameTypeEnum::getNameTypeById, (v1, v2) -> v1));
    }

}