package cn.smarthse.dy.dto.offlineTraining;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Accessors(chain = true)
@Data
public class OfflineTrainingQrSignOutParam implements Serializable {

    /**
     * 培训项目ID
     */
    @NotNull(message = "培训项目ID不能为空")
    private Long trainProjId;

    /**
     * 人员姓名
     */
    @NotBlank(message = "人员姓名不能为空")
    private String name;

    /**
     * 身份证
     */
    @NotBlank(message = "身份证不能为空")
    private String idCard;

}
