package cn.smarthse.dy.dto.offlineTraining;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Accessors(chain = true)
@Data
public class OfflineTrainingQrEditParam implements Serializable {

    /**
     * 培训项目ID
     */
    @NotNull(message = "培训项目ID不能为空")
    private Long trainProjId;

    /**
     * 人员姓名
     */
    @NotBlank(message = "人员姓名不能为空")
    private String name;

    /**
     * 身份证
     */
    @NotBlank(message = "身份证不能为空")
    private String idCard;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String tel;

    /**
     * 单位id
     */
    @NotNull(message = "单位id不能为空")
    private Long cid;

    /**
     * 单位名称（冗余）
     */
    @NotBlank(message = "单位名称不能为空")
    private String companyName;

    /**
     * 培训人员类型，CertificateStaffNameTypeEnum
     */
    @NotBlank(message = "培训人员类型不能为空")
    private String trainPersonnelType;

}
