package cn.smarthse.dy.dto.offlineTraining;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Accessors(chain = true)
@Data
public class OfflineTrainingProjEditParam implements Serializable {

    private Long loginUserId;

    @NotNull(message = "培训项目ID不能为空")
    private Long id;

    /**
     * 培训档案状态，TrainProfileStatusEnum
     */
    @NotNull(message = "培训档案状态不能为空")
    private Byte trainProfileStatus;

    /**
     * 培训项目名称
     */
    private String trainProjName;

    /**
     * 培训发布单位
     */
    private String trainPublishUnit;

    /**
     * 培训开始时间
     */
    private Date trainBeginDate;

    /**
     * 培训结束时间
     */
    private Date trainEndDate;

    /**
     * 培训人员类型（英文逗号分割），CertificateStaffNameTypeEnum
     */
    private String trainPersonnelType;

    /**
     * 培训内容
     */
    private String trainContent;

    /**
     * 培训区域id
     */
    private Long trainAreaId;

}
