package cn.smarthse.dy.dto.offlineTraining;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Accessors(chain = true)
@Data
public class OfflineTrainingCompanyEditParam implements Serializable {

    private Long loginUserId;

    /**
     * ID
     */
    @NotNull(message = "企业id不能为空")
    private Long id;
    /**
     * 企业名称
     */
    @NotBlank(message = "企业名称不能为空")
    private String name;
    /**
     * 信用代码
     */
    @NotBlank(message = "信用代码不能为空")
    private String unifiedSocialCc;
    /**
     * 行政区划
     */
    @NotNull(message = "行政区划不能为空")
    private Long detailAreaId;
    /**
     * 所属行业
     */
    @NotNull(message = "所属行业不能为空")
    private Long industryCategory;

}
