package cn.smarthse.dy.dto.home;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Accessors(chain = true)
@Data
public class DyHomePersonnelParam extends JqGridParam implements Serializable {

    private Long userAreaId;
    private Byte userAreaLevel;

    /**
     * 选中的区域id
     */
    private Long searchAreaId;
    private Byte searchAreaLevel;

    @ApiModelProperty("角色 17-属地乡镇辅助监督员 18-医共体医务人员")
    private Long roleId;

    @ApiModelProperty(hidden = true)
    private Date searchDate;

    /**
     * 接害人数：
     * 1->默认不勾选,展示接害人数≥3人或无数据企业的数据;
     * 2->勾选后，展示接害人数<3人+接害人数≥3人或无数据企业的数据;
     */
    @ApiModelProperty(value = "接害人数(1-不勾选；2-勾选)")
    private Integer pickupCount;
}
