package cn.smarthse.dy.dto.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class PersonnelDto implements Serializable {

    @NotNull(message = "区域id不能为空")
    @ApiModelProperty(value = "区域id", required = true, example = "330783110000")
    private Long areaId;

    @NotBlank(message = "用户所在单位不能为空")
    @ApiModelProperty(value = "用户所在单位", required = true, example = "用户所在单位")
    private String organizationName;

    @NotBlank(message = "用户姓名不能为空")
    @ApiModelProperty(value = "用户姓名", required = true, example = "用户姓名")
    private String fullName;

    @NotBlank(message = "手机号不能为空")
    @ApiModelProperty(value = "手机号", required = true, example = "15068")
    private String tel;

    @NotEmpty(message = "角色不能为空")
    @ApiModelProperty(value = "角色 17-属地乡镇辅助监督员 18-医共体医务人员", required = true, example = "[17,18]")
    private List<Long> roleList;

    @NotNull(message = "浙政钉accoundId不能为空")
    @ApiModelProperty(value = "浙政钉accoundId", required = true, example = "123456")
    private Long accountId;

    @NotBlank(message = "数据来源ID不能为空")
    @ApiModelProperty(value = "数据来源ID", required = true, example = "ABC")
    private String dataSourceId;

    @NotNull(message = "是否有效不能为空")
    @ApiModelProperty(value = "是否有效（0-无效，1-有效）", required = true, example = "true")
    private Boolean isValid;

}