package cn.smarthse.dy.dto.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class CompanyAddDto {

    @NotBlank(message = "数据来源ID不能为空")
    @ApiModelProperty(value = "数据来源ID（原ID）", required = true, example = "ABC")
    private String dataSourceId;

    @NotBlank(message = "企业名称不能为空")
    @ApiModelProperty(value = "企业名称", required = true, example = "东阳测试企业")
    private String name;

    @NotBlank(message = "统一社会信用代码不能为空")
    @ApiModelProperty(value = "统一社会信用代码", required = true, example = "123456789123456789")
    private String unifiedSocialCc;

    @NotNull(message = "区域id不能为空")
    @ApiModelProperty(value = "区域id", required = true, example = "330783110000")
    private Long detailAreaId;

    @NotNull(message = "营业状态不能为空")
    @ApiModelProperty(value = "营业状态(0:关闭;1:正常;2:暂停营业)", required = true, example = "1")
    private Byte businessState;

    //@NotNull(message = "行业分类id不能为空")
    @ApiModelProperty(value = "行业分类id", required = false, example = "2481")
    private Long industryCategory;

    @ApiModelProperty(value = "法人代表姓名", example = "法人代表姓名")
    private String legalName;

    @ApiModelProperty(value = "法人代表联系电话", example = "15068")
    private String legalTel;

    @NotBlank(message = "职业卫生管理联系人不能为空")
    @ApiModelProperty(value = "职业卫生管理联系人", example = "职业卫生管理联系人", required = true)
    private String occManagerName;

    @NotBlank(message = "职业卫生管理联系人电话不能为空")
    @ApiModelProperty(value = "职业卫生管理联系人电话", example = "15068", required = true)
    private String occManagerTel;

    @ApiModelProperty(value = "企业主要负责人", example = "企业主要负责人")
    private String mainLeaderName;

    @ApiModelProperty(value = "企业主要负责人手机号码", example = "15068")
    private String mainLeaderTel;

}