package cn.smarthse.bx.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class BxCompanyVo implements Serializable {

    @ApiModelProperty("企业id")
    private Long id;

    @ApiModelProperty("单位名称")
    private String name;

    @ApiModelProperty("营业状态（1-正常，2-暂停营业，0-关闭）")
    private Byte businessState;

    @ApiModelProperty("统一信用代码")
    private String unifiedSocialCc;

    @ApiModelProperty("行政区划id")
    private Long areaId;

    @ApiModelProperty("详细地址")
    private String workAddress;

    @ApiModelProperty("法人代表姓名")
    private String legalName;

    @ApiModelProperty("法人代表联系电话")
    private String legalTel;

    @ApiModelProperty("企业主要负责人")
    private String mainLeaderName;

    @ApiModelProperty("负责人手机号码")
    private String mainLeaderTel;

    @ApiModelProperty("申报年份")
    private String declareYear;

    @ApiModelProperty("监督单位名称")
    private String supervisionUnitName;

    @ApiModelProperty("企业规模（1-大型企业，2-中型企业，3-小型企业，4-微型企业，5-未划分）")
    private String scale;

    @ApiModelProperty("行业分类id")
    private Long industryCategory;

    @ApiModelProperty("职业卫生管理联系人")
    private String occManagerName;

    @ApiModelProperty("职业卫生管理联系人电话")
    private String occManagerTel;

    @ApiModelProperty("接害人数")
    private String harmStaffCount;

    @ApiModelProperty("创建时间")
    private Date createDate;

    @ApiModelProperty("更新时间")
    private Date updateDate;

    @ApiModelProperty("是否删除")
    private Boolean isDel;

}
