package cn.smarthse.bx.vo;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 巡查信息
 *
 * @author chuhy
 * @date 2025/2/8 8:46
 */
@Data
public class BXPatrolVo implements Serializable {

    /**
     * 巡查记录id
     */
    @ApiModelProperty(value = "巡查记录id")
    private Long id;

    /**
     * 企业id
     */
    @ApiModelProperty(value = "企业id")
    private Long cid;

    /**
     * 巡查名称
     */
    @ApiModelProperty(value = "巡查名称")
    private String patrolName;

    /**
     * 行政区划id
     */
    @ApiModelProperty(value = "行政区划id")
    private Long areaId;

    // /**
    //  * 单位名称
    //  */
    // @ApiModelProperty(value="单位名称")
    // private String unitName;

    /**
     * 巡查人员id（tm_patrol_info.user_id）
     */
    @ApiModelProperty(value = "巡查人员id")
    private Long patrolPeopleId;

    /**
     * 巡查人
     */
    @ApiModelProperty(value = "巡查人")
    private String patrolPeople;

    /**
     * 巡查人手机号
     */
    @ApiModelProperty(value = "巡查人手机号")
    private String patrolPeopleNumber;

    /**
     * 巡查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已中止)
     */
    @ApiModelProperty(value = "巡查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已中止)")
    private Integer patrolStatus;

    /**
     * 巡查时间
     */
    @ApiModelProperty(value = "巡查时间")
    private Date patrolTime;

    /**
     * 中止类型(1-企业暂停；2-企业关闭；3-区域变更)
     */
    @ApiModelProperty(value = "中止类型(1-企业暂停；2-企业关闭；3-区域变更)")
    private Integer stopType;

    /**
     * 企业负责人签字(陪同人签名)
     */
    @ApiModelProperty(value = "企业负责人签字(陪同人签名)", hidden = true)
    private Long unitManageSign;

    /**
     * 企业负责人签字Url(陪同人签名)
     */
    @ApiModelProperty(value = "企业负责人签字Url(陪同人签名)")
    private String unitManageSignUrl;

    /**
     * 巡查痕迹附件
     */
    @ApiModelProperty(value = "巡查痕迹附件(签名)", hidden = true)
    private String patrolFile;

    /**
     * 巡查痕迹附件Url
     */
    @ApiModelProperty(value = "巡查痕迹附件Url")
    private List<SysFileModel> patrolFileUrl;

    /**
     * 巡查年份
     */
    @ApiModelProperty(value = "巡查年份")
    private Integer year;


    // ************************************* 巡查项 *************************************
    @ApiModelProperty(value = "有无职业病危害因素定期检测或评价（1-有；0-无）", example = "1")
    private Integer ifExistsCheck;

    @ApiModelProperty(value = "有无申报（1-有；0-无）", example = "0")
    private Integer ifExistsDeclare;

    @ApiModelProperty(value = "有无职业健康检查（1-有；0-无）", example = "1")
    private Integer ifExistsHealth;

    @ApiModelProperty(value = "有无建立职业卫生管理档案（1-有；0-无）", example = "0")
    private Integer ifExistsHseFile;

    @ApiModelProperty(value = "有无防护用品（1-有；0-无）", example = "1")
    private Integer ifExistsPpe;

    @ApiModelProperty(value = "有无开展建设项目三同时（1-有；0-无；2-合理缺项）", example = "0")
    private Integer ifExistsThree;

    @ApiModelProperty(value = "有无主要负责人和职业卫生管理人员培训（1-有；0-无）", example = "1")
    private Integer ifExistsTrain;

    @ApiModelProperty(value = "有无警示标识（1-有；0-无）", example = "0")
    private Integer ifExistsWarning;
    // ************************************* 巡查项 *************************************


    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "最后修改时间")
    private LocalDateTime updateDate;

}
