package cn.smarthse.bx.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class BxBaseParam implements Serializable {

    @ApiModelProperty(value = "页码", required = true, example = "1", notes = "默认1")
    private int page = 1;

    @ApiModelProperty(value = "每页几条记录", required = true, example = "1000", notes = "默认1000")
    private int rows = 1000;

    @ApiModelProperty(value = "开始时间", example = "2025-01-01")
    private Date beginTime;

    @ApiModelProperty(value = "结束时间", example = "2025-12-10")
    private Date endTime;

    @ApiModelProperty("行政区划id")
    private Long searchAreaId;
    @ApiModelProperty(hidden = true)
    private Byte searchAreaLevel;

}
