/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.datasync.task;

import cn.hutool.http.HttpUtil;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StSubmitTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StSubmitTask.class);
    @Value(value="${project.st-rest-address:localhost:5801}")
    private String stRestAddress;
    private static final String JOB_INFO_URL = "/hazelcast/rest/maps/job-info/";
    private static final String SUBMIT_JOB_URL = "/hazelcast/rest/maps/submit-job";
    private static final String RUNNING_JOBS_URL = "/hazelcast/rest/maps/running-jobs";
    @Resource
    RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="StSubmitTask-receiveTaskInfo")
    @Transactional(readOnly=false)
    public void receiveTaskInfo() {
        block19: {
            String jobParam = XxlJobHelper.getJobParam();
            if (StringUtils.isBlank((CharSequence)jobParam)) {
                XxlJobHelper.log((String)"\u53c2\u6570\u4e3a\u7a7a\u4e0d\u80fd\u6267\u884c\u4efb\u52a1", (Object[])new Object[0]);
                return;
            }
            Config jobConfig = ConfigFactory.parseString((String)jobParam);
            Config envObjct = jobConfig.getConfig("env");
            if (envObjct == null) {
                XxlJobHelper.log((String)"\u627e\u4e0d\u5230env\u914d\u7f6e\u8282\u70b9", (Object[])new Object[0]);
                return;
            }
            String submitJobName = envObjct.getString("job.name");
            String jobMode = envObjct.getString("job.mode");
            if (submitJobName == null) {
                XxlJobHelper.log((String)"\u627e\u4e0d\u5230job.name\u914d\u7f6e\u8282\u70b9", (Object[])new Object[0]);
                return;
            }
            RLock lock = this.redissonClient.getLock("st-submitjob:" + submitJobName);
            try {
                if (lock.tryLock(10L, TimeUnit.SECONDS)) {
                    String runningJobsResponse = HttpUtil.get((String)(this.stRestAddress + RUNNING_JOBS_URL));
                    JSONArray jsonArray = JSON.parseArray((String)runningJobsResponse);
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject jobInfo = jsonArray.getJSONObject(i);
                        String jobName = jobInfo.getString("jobName");
                        if (!jobName.equals(submitJobName)) continue;
                        XxlJobHelper.log((String)"jobName\uff1a{}\uff0c\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4", (Object[])new Object[]{jobName});
                        return;
                    }
                    String jobConfigJson = jobConfig.root().render(ConfigRenderOptions.concise());
                    JSONObject jsonObject = JSON.parseObject((String)jobConfigJson);
                    this.handConfig(jsonObject);
                    String submitJobResponse = HttpUtil.post((String)(this.stRestAddress + SUBMIT_JOB_URL), (String)JSON.toJSONString((Object)jsonObject));
                    JSONObject submitJobJson = JSON.parseObject((String)submitJobResponse);
                    String submitJobId = submitJobJson.getString("jobId");
                    if (StringUtils.isBlank((CharSequence)submitJobId)) {
                        XxlJobHelper.log((String)"\u4efb\u52a1\u63d0\u4ea4\u4e0d\u6210\u529f\uff0c {}", (Object[])new Object[]{submitJobResponse});
                        return;
                    }
                    if (!"BATCH".equalsIgnoreCase(jobMode)) {
                        XxlJobHelper.log((String)"submitJobId\uff1a{}\uff0c cdc\u6570\u636e.. \u4efb\u52a1\u63d0\u4ea4\u6210\u529f", (Object[])new Object[]{submitJobId});
                        return;
                    }
                    while (true) {
                        String jobInfoResponse = HttpUtil.get((String)(this.stRestAddress + JOB_INFO_URL + submitJobId));
                        JSONObject jobInfoJson = JSON.parseObject((String)jobInfoResponse);
                        String jobId = jobInfoJson.getString("jobId");
                        String jobName = jobInfoJson.getString("jobName");
                        String jobStatus = jobInfoJson.getString("jobStatus");
                        String errorMsg = jobInfoJson.getString("errorMsg");
                        String createTime = jobInfoJson.getString("createTime");
                        JSONObject metricsObject = jobInfoJson.getJSONObject("metrics");
                        String sourceReceivedCount = metricsObject.getString("SourceReceivedCount");
                        String sinkWriteCount = metricsObject.getString("SinkWriteCount");
                        String readQPS = metricsObject.getJSONObject("TableSourceReceivedQPS").getString("Optional[source]");
                        String writeQPS = metricsObject.getString("SinkWriteQPS");
                        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                            XxlJobHelper.log((String)"\u4efb\u52a1\u5f02\u5e38:{}", (Object[])new Object[]{jobInfoJson.getString("errorMsg")});
                        }
                        if (!"RUNNING".equals(jobStatus)) {
                            String finishedTime = jobInfoJson.getString("finishTime");
                            XxlJobHelper.log((String)"\u4efb\u52a1\u6267\u884c\u72b6\u6001:{},\u8bfb\u53d6\u603b\u6570:{}, \u5199\u5165\u603b\u6570\uff1a{}, \u5b8c\u6210\u65f6\u95f4:{}", (Object[])new Object[]{jobStatus, sourceReceivedCount, sinkWriteCount, finishedTime});
                            break block19;
                        }
                        XxlJobHelper.log((String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c, \u6e90\u6570\u636e\u63a5\u6536\u6570:{}--readQPS:{}, \u76ee\u6807\u6e90\u6570\uff1a{}--writeQPS:{}", (Object[])new Object[]{sourceReceivedCount, readQPS, sinkWriteCount, writeQPS});
                        Thread.sleep(5000L);
                    }
                }
                XxlJobHelper.log((String)"\u6709\u4efb\u52a1\u6b63\u5728\u63d0\u4ea4.. \u672a\u83b7\u5f97\u9501\u4e0d\u80fd\u6267\u884c", (Object[])new Object[0]);
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u4efb\u52a1\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
                XxlJobHelper.log((String)"\u6267\u884c\u4efb\u52a1\u53d1\u751f\u5f02\u5e38:{}", (Object[])new Object[]{e});
            }
            finally {
                if (lock != null && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
    }

    public void handConfig(JSONObject jsonObject) {
        JSONObject sinkObject = jsonObject.getJSONObject("sink");
        JSONArray sinkPluginList = new JSONArray();
        JSONArray sinkResultList = new JSONArray();
        if (sinkObject instanceof JSONObject) {
            sinkPluginList.add((Object)sinkObject);
        } else {
            sinkPluginList = jsonObject.getJSONArray("sink");
        }
        for (Object sinkPlugin : sinkPluginList) {
            JSONObject sinkPluginJson = (JSONObject)sinkPlugin;
            Set sinkPluginNameSet = sinkPluginJson.keySet();
            Iterator iterator = sinkPluginNameSet.iterator();
            while (iterator.hasNext()) {
                String sinkPluginName = (String)iterator.next();
                JSONObject jsonObjectResult = sinkPluginJson.getJSONObject(sinkPluginName);
                jsonObjectResult.put((Object)"plugin_name", (Object)sinkPluginName);
                sinkResultList.add((Object)jsonObjectResult);
            }
        }
        jsonObject.put((Object)"sink", (Object)sinkResultList);
        JSONObject transformObject = jsonObject.getJSONObject("transform");
        if (transformObject != null) {
            JSONArray transformPluginList = new JSONArray();
            JSONArray transformResultList = new JSONArray();
            if (transformObject instanceof JSONObject) {
                transformPluginList.add((Object)transformObject);
            } else {
                transformPluginList = jsonObject.getJSONArray("transform");
            }
            for (Object transformPlugin : transformPluginList) {
                JSONObject transformPluginJson = (JSONObject)transformPlugin;
                Set transformPluginNameSet = transformPluginJson.keySet();
                for (String transformPluginName : transformPluginNameSet) {
                    JSONObject jsonObjectResult = transformPluginJson.getJSONObject(transformPluginName);
                    jsonObjectResult.put((Object)"plugin_name", (Object)transformPluginName);
                    transformResultList.add((Object)jsonObjectResult);
                }
            }
            jsonObject.put((Object)"transform", (Object)transformResultList);
        }
        JSONObject sourceObject = jsonObject.getJSONObject("source");
        JSONArray sourcePluginList = new JSONArray();
        JSONArray sourceResultList = new JSONArray();
        if (sourceObject instanceof JSONObject) {
            sourcePluginList.add((Object)sourceObject);
        } else {
            sourcePluginList = jsonObject.getJSONArray("source");
        }
        for (Object sourcePlugin : sourcePluginList) {
            JSONObject sourcePluginJson = (JSONObject)sourcePlugin;
            Set sourcePluginNameKey = sourcePluginJson.keySet();
            for (String sourcePluginName : sourcePluginNameKey) {
                JSONObject jsonObjectResult = sourcePluginJson.getJSONObject(sourcePluginName);
                jsonObjectResult.put((Object)"plugin_name", (Object)sourcePluginName);
                sourceResultList.add((Object)jsonObjectResult);
            }
        }
        jsonObject.put((Object)"source", (Object)sourceResultList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="CheckTask-byJobName")
    public void byJobName() {
        String jobParam = XxlJobHelper.getJobParam();
        if (StringUtils.isBlank((CharSequence)jobParam)) {
            XxlJobHelper.log((String)"\u53c2\u6570\u4e3a\u7a7a\u4e0d\u80fd\u6267\u884c\u4efb\u52a1", (Object[])new Object[0]);
            return;
        }
        JSONObject jobConfig = JSON.parseObject((String)jobParam);
        String jobnames = jobConfig.getString("jobnames");
        if (StringUtils.isBlank((CharSequence)jobnames)) {
            XxlJobHelper.log((String)"\u627e\u4e0d\u5230jobnames\u5c5e\u6027", (Object[])new Object[0]);
            return;
        }
        RLock lock = this.redissonClient.getLock("CheckTask-byJobName");
        try {
            if (lock.tryLock(10L, TimeUnit.SECONDS)) {
                String runningJobsResponse = HttpUtil.get((String)(this.stRestAddress + RUNNING_JOBS_URL));
                JSONArray jsonArray = JSON.parseArray((String)runningJobsResponse);
                HashSet<String> jobNameSet = new HashSet<String>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jobInfo = jsonArray.getJSONObject(i);
                    String jobName = jobInfo.getString("jobName");
                    jobNameSet.add(jobName);
                }
                HashSet<String> failJobSet = new HashSet<String>();
                for (String jobname : StringUtils.splitByWholeSeparator((String)jobnames, (String)",")) {
                    if (StringUtils.isBlank((CharSequence)jobname) || jobNameSet.contains(jobname)) continue;
                    failJobSet.add(jobname);
                }
                if (CollectionUtils.isNotEmpty(failJobSet)) {
                    XxlJobHelper.log((String)"\u4efb\u52a1:{}\u5df2\u505c\u6b62", (Object[])new Object[]{StringUtils.join((Object[])new Set[]{failJobSet})});
                    XxlJobHelper.handleFail((String)("\u4efb\u52a1:\u3010" + StringUtils.join((Object[])new Set[]{failJobSet}) + "\u3011\u5df2\u505c\u6b62"));
                }
            } else {
                XxlJobHelper.log((String)"\u6b63\u5728\u68c0\u67e5st \u670d\u52a1", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("\u6b63\u5728\u68c0\u67e5st\u4efb\u52a1\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            XxlJobHelper.log((String)"\u6b63\u5728\u68c0\u67e5st\u4efb\u52a1\u53d1\u751f\u5f02\u5e38:{}", (Object[])new Object[]{e});
        }
        finally {
            if (lock != null && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }
}

