/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.datasync.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.es.esservice.IOrigiCipIdEsService;
import cn.smarthse.es.model.OrigiCipIdModel;
import cn.smarthse.es.model.OrigiCipIdParamModel;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrigiCipIdEsTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrigiCipIdEsTask.class);
    @DubboReference
    private IOrigiCipIdEsService origiCipIdEsService;
    @Autowired(required=false)
    private FieldEncryptorProperties fieldEncryptionProperties;
    private EncryptContext encryptContext;

    @PostConstruct
    public void init() {
        this.initEncryptContext();
    }

    @XxlJob(value="es-save")
    public void esSave(String orgiData, String cipData) {
        if (CharSequenceUtil.isBlank((CharSequence)orgiData)) {
            orgiData = this.getParamValue("orgiData");
        }
        if (CharSequenceUtil.isBlank((CharSequence)cipData)) {
            cipData = this.getParamValue("cipData");
        }
        if (CharSequenceUtil.isBlank((CharSequence)orgiData) || CharSequenceUtil.isBlank((CharSequence)cipData)) {
            XxlJobHelper.log((String)"\u9700\u5165\u53c2\uff01", (Object[])new Object[0]);
            log.error("\u9700\u5165\u53c2\uff01");
            return;
        }
        ArrayList<OrigiCipIdModel> list = new ArrayList<OrigiCipIdModel>();
        OrigiCipIdModel e = new OrigiCipIdModel();
        e.setOrgiData(orgiData);
        e.setCipData(cipData);
        e.setIsIdConverted(Boolean.TRUE);
        try {
            EncryptUtils.decryptBySm4((String)orgiData, (String)this.encryptContext.getPassword());
        }
        catch (Exception ex) {
            e.setIsIdConverted(null);
        }
        list.add(e);
        String esCipData = this.esSelect(orgiData);
        this.origiCipIdEsService.batchSave(list);
        if (CharSequenceUtil.isBlank((CharSequence)esCipData)) {
            XxlJobHelper.log((String)"\u63d2\u5165es[1]\u6761", (Object[])new Object[0]);
            log.error("\u63d2\u5165es[1]\u6761");
        } else {
            XxlJobHelper.log((String)"\u66f4\u65b0es[1]\u6761", (Object[])new Object[0]);
            log.error("\u66f4\u65b0es[1]\u6761");
        }
    }

    @XxlJob(value="es-select")
    public String esSelect(String orgiDataSM4) {
        String cipData;
        if (CharSequenceUtil.isBlank((CharSequence)orgiDataSM4)) {
            orgiDataSM4 = this.getParamValue("orgiData");
        }
        if (CharSequenceUtil.isBlank((CharSequence)orgiDataSM4)) {
            XxlJobHelper.log((String)"\u9700\u5165\u53c2\uff01", (Object[])new Object[0]);
            log.error("\u9700\u5165\u53c2\uff01");
            return null;
        }
        ArrayList<String> orgiDataSM4List = new ArrayList<String>();
        orgiDataSM4List.add(orgiDataSM4);
        OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
        esParam.setOrgiDatas(orgiDataSM4List);
        PageInfo esPage = this.origiCipIdEsService.pageByPlaintextList(esParam, 1, 1);
        List esList = esPage.getList();
        if (CollUtil.isEmpty((Collection)esList)) {
            XxlJobHelper.log((String)"\u67e5\u5230es\u7ed3\u679c[{}]\u6761", (Object[])new Object[]{0});
            log.error("\u67e5\u5230es\u7ed3\u679c[{}]\u6761", (Object)0);
            cipData = null;
        } else {
            int size = esList.size();
            OrigiCipIdModel esModel = (OrigiCipIdModel)esList.get(0);
            cipData = esModel.getCipData();
            XxlJobHelper.log((String)"\u67e5\u5230es\u7ed3\u679c[{}]\u6761::\u503c[{}]", (Object[])new Object[]{size, cipData});
            log.error("\u67e5\u5230es\u7ed3\u679c[{}]\u6761::\u503c[{}]", (Object)size, (Object)cipData);
        }
        return cipData;
    }

    @XxlJob(value="es-delete")
    public void esDeleteById(String orgiDataSM4) {
        if (CharSequenceUtil.isBlank((CharSequence)orgiDataSM4)) {
            orgiDataSM4 = this.getParamValue("orgiData");
        }
        if (CharSequenceUtil.isBlank((CharSequence)orgiDataSM4)) {
            XxlJobHelper.log((String)"\u9700\u5165\u53c2\uff01", (Object[])new Object[0]);
            log.error("\u9700\u5165\u53c2\uff01");
            return;
        }
        this.origiCipIdEsService.deleteById(orgiDataSM4);
        XxlJobHelper.log((String)"\u5220\u9664es[1]\u6761", (Object[])new Object[0]);
        log.error("\u5220\u9664es[1]\u6761");
    }

    private String getParamValue(String paramName) {
        JSONObject jsonObj;
        String paramValue = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (CharSequenceUtil.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            paramValue = jsonObj.getString(paramName);
        }
        return paramValue;
    }

    private void initEncryptContext() {
        this.encryptContext = new EncryptContext();
        this.encryptContext.setDataProcessingMethodsType(DataProcessingMethodsType.ACCURATE);
        this.encryptContext.setMiddlewareEnabled(this.fieldEncryptionProperties.getMiddlewareEnabled());
        this.encryptContext.setAlgorithm(AlgorithmType.getByName((String)this.fieldEncryptionProperties.getAlgorithm()));
        FieldEncryptorProperties.GroupConfig maxVersionGroupConfig = this.fieldEncryptionProperties.getMaxVersionGroupConfig();
        this.encryptContext.setVersion(maxVersionGroupConfig.getVersion());
        this.encryptContext.setPassword(maxVersionGroupConfig.getPassword());
        this.encryptContext.setPublicKey(maxVersionGroupConfig.getPublicKey());
        this.encryptContext.setPrivateKey(maxVersionGroupConfig.getPrivateKey());
    }
}

