/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.datasync.task;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.es.esservice.IOrigiCipIdEsService;
import cn.smarthse.es.model.OrigiCipIdModel;
import cn.smarthse.es.model.OrigiCipIdParamModel;
import cn.smarthse.services.datasync.pojo.model.NeedEncryptFieldParam;
import cn.smarthse.services.datasync.service.encrypt.ICryptoService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EncryptFieldTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptFieldTask.class);
    @Autowired
    private ICryptoService cryptoComService;
    @DubboReference
    private IOrigiCipIdEsService origiCipIdEsService;

    @XxlJob(value="cryptoTask-flag")
    public void setBooleanFlagValue(String ids, String i, String b) {
        if (CharSequenceUtil.isBlank((CharSequence)ids)) {
            ids = this.getParamValue("ids");
        }
        if (i == null) {
            i = this.getParamValue("i");
        }
        if (b == null) {
            b = this.getParamValue("b");
        }
        this.cryptoComService.setBooleanFlagValue(ids, Convert.toInt((Object)i), Convert.toBool((Object)b));
        XxlJobHelper.log((String)"\u8bbe\u7f6e\u52a0\u5bc6\u5e03\u5c14\u503c\u5b8c\u6210", (Object[])new Object[0]);
    }

    @XxlJob(value="cryptoTask-encrypt")
    public void encryptData(String encrypt) {
        XxlJobHelper.log((String)"--------------------> \u52a0\u5bc6\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        if (CharSequenceUtil.isBlank((CharSequence)encrypt)) {
            encrypt = this.getParamValue("encrypt");
        }
        String decrypt = this.cryptoComService.encryptData(encrypt);
        XxlJobHelper.log((String)decrypt, (Object[])new Object[0]);
        log.error(decrypt);
        XxlJobHelper.log((String)"--------------------> \u52a0\u5bc6\u7ed3\u675f <--------------------", (Object[])new Object[0]);
    }

    @XxlJob(value="cryptoTask-decrypt")
    public void decryptData(String decrypt) {
        XxlJobHelper.log((String)"--------------------> \u89e3\u5bc6\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        if (CharSequenceUtil.isBlank((CharSequence)decrypt)) {
            decrypt = this.getParamValue("decrypt");
        }
        String encrypt = this.cryptoComService.decryptData(decrypt);
        XxlJobHelper.log((String)encrypt, (Object[])new Object[0]);
        log.error(encrypt);
        XxlJobHelper.log((String)"--------------------> \u89e3\u5bc6\u7ed3\u675f <--------------------", (Object[])new Object[0]);
    }

    @XxlJob(value="es-convert-1")
    public void esConvert_1(String plaintext) {
        XxlJobHelper.log((String)"--------------------> \u8f6c\u63621\u6761\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        if (CharSequenceUtil.isBlank((CharSequence)plaintext)) {
            plaintext = this.getParamValue("plaintext");
        }
        this.cryptoComService.esConvert(plaintext);
        XxlJobHelper.log((String)"--------------------> \u8f6c\u63621\u6761\u7ed3\u675f <--------------------", (Object[])new Object[0]);
    }

    @XxlJob(value="es-convert")
    public void esConvert() {
        XxlJobHelper.log((String)"--------------------> \u8f6c\u6362\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        this.cryptoComService.esConvert(null);
        XxlJobHelper.log((String)"--------------------> \u8f6c\u6362\u7ed3\u675f <--------------------", (Object[])new Object[0]);
    }

    @XxlJob(value="cryptoTask-\u603b\u4efb\u52a1")
    public void encryptTask() {
        XxlJobHelper.log((String)"--------------------> cryptoTask-\u603b\u4efb\u52a1::\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        long l1 = System.currentTimeMillis();
        this.cryptoComService.encryptToEs(null);
        this.cryptoComService.encryptToBusiness(null);
        long l2 = System.currentTimeMillis();
        XxlJobHelper.log((String)"--------------------> cryptoTask-\u603b\u4efb\u52a1::\u7ed3\u675f <--------------------", (Object[])new Object[0]);
        XxlJobHelper.log((String)"cryptoTask-\u603b\u4efb\u52a1::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{l2 - l1});
    }

    @XxlJob(value="cryptoTask-1")
    public void encryptToEs() {
        XxlJobHelper.log((String)"--------------------> cryptoTask-1::\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        long l1 = System.currentTimeMillis();
        this.cryptoComService.encryptToEs(null);
        long l2 = System.currentTimeMillis();
        XxlJobHelper.log((String)"--------------------> cryptoTask-1::\u7ed3\u675f <--------------------", (Object[])new Object[0]);
        XxlJobHelper.log((String)"cryptoTask-1::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{l2 - l1});
    }

    @XxlJob(value="cryptoTask-1-batch")
    public void encryptToEsBatch() {
        XxlJobHelper.log((String)"--------------------> cryptoTask-1-batch::\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        long l1 = System.currentTimeMillis();
        NeedEncryptFieldParam param = new NeedEncryptFieldParam();
        param.setRemark("batch");
        this.cryptoComService.encryptToEs(param);
        long l2 = System.currentTimeMillis();
        XxlJobHelper.log((String)"--------------------> cryptoTask-1-batch::\u7ed3\u675f <--------------------", (Object[])new Object[0]);
        XxlJobHelper.log((String)"cryptoTask-1-batch::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{l2 - l1});
    }

    @XxlJob(value="cryptoTask-2")
    public void encryptToBusiness(Boolean hg) {
        XxlJobHelper.log((String)"--------------------> cryptoTask-2::\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        long l1 = System.currentTimeMillis();
        if (hg == null) {
            String hgValue = this.getParamValue("hg");
            hg = Convert.toBool((Object)hgValue);
        }
        NeedEncryptFieldParam param = new NeedEncryptFieldParam();
        param.setHg(hg);
        this.cryptoComService.encryptToBusiness(param);
        long l2 = System.currentTimeMillis();
        XxlJobHelper.log((String)"--------------------> cryptoTask-2::\u7ed3\u675f <--------------------", (Object[])new Object[0]);
        XxlJobHelper.log((String)"cryptoTask-2::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{l2 - l1});
    }

    @XxlJob(value="cryptoTask-de")
    public void decryptToBusiness(Boolean hg) {
        XxlJobHelper.log((String)"--------------------> cryptoTask-de::\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        long l1 = System.currentTimeMillis();
        if (hg == null) {
            String hgValue = this.getParamValue("hg");
            hg = Convert.toBool((Object)hgValue);
        }
        NeedEncryptFieldParam param = new NeedEncryptFieldParam();
        param.setHg(hg);
        this.cryptoComService.decryptToBusiness(param);
        long l2 = System.currentTimeMillis();
        XxlJobHelper.log((String)"--------------------> cryptoTask-de::\u7ed3\u675f <--------------------", (Object[])new Object[0]);
        XxlJobHelper.log((String)"cryptoTask-de::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{l2 - l1});
    }

    @XxlJob(value="cryptoTask-pageByCipher")
    public void testPageByCiphertextList(String ciphertext) {
        XxlJobHelper.log((String)"--------------------> cryptoTask-pageByCipher::\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        long l1 = System.currentTimeMillis();
        if (CharSequenceUtil.isBlank((CharSequence)ciphertext)) {
            ciphertext = this.getParamValue("ciphertext");
        }
        OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
        esParam.setCipDatas((List)ListUtil.toList((Object[])new String[]{ciphertext}));
        PageInfo esPage = this.origiCipIdEsService.pageByCiphertextList(esParam, 1, 1, Boolean.TRUE);
        List esList = esPage.getList();
        XxlJobHelper.log((String)"\u53d6es\u503c\u89e3\u5bc6[{}]", (Object[])new Object[]{esList.get(0)});
        log.error("\u53d6es\u503c\u89e3\u5bc6[{}]", esList.get(0));
        long l2 = System.currentTimeMillis();
        XxlJobHelper.log((String)"--------------------> cryptoTask-pageByCipher::\u7ed3\u675f <--------------------", (Object[])new Object[0]);
        XxlJobHelper.log((String)"cryptoTask-pageByCipher::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{l2 - l1});
    }

    public static void main(String[] args) {
        OrigiCipIdModel origiCipIdModel = new OrigiCipIdModel();
        origiCipIdModel.setCipData("11");
        origiCipIdModel.setOrgiData("22");
        log.error("\u6253\u5370\u5f02\u5e38::{}", (Object)origiCipIdModel);
    }

    @XxlJob(value="cryptoTask-2-batch")
    public void encryptToBusinessBatch(Boolean hg) {
        XxlJobHelper.log((String)"--------------------> cryptoTask-2-batch::\u5f00\u59cb <--------------------", (Object[])new Object[0]);
        long l1 = System.currentTimeMillis();
        if (hg == null) {
            String hgValue = this.getParamValue("hg");
            hg = Convert.toBool((Object)hgValue);
        }
        NeedEncryptFieldParam param = new NeedEncryptFieldParam();
        param.setRemark("batch");
        param.setHg(hg);
        this.cryptoComService.encryptToBusiness(param);
        long l2 = System.currentTimeMillis();
        XxlJobHelper.log((String)"--------------------> cryptoTask-2-batch::\u7ed3\u675f <--------------------", (Object[])new Object[0]);
        XxlJobHelper.log((String)"cryptoTask-2-batch::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{l2 - l1});
    }

    private String getParamValue(String paramName) {
        JSONObject jsonObj;
        String paramValue = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (CharSequenceUtil.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            paramValue = jsonObj.getString(paramName);
        }
        return paramValue;
    }
}

