/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.datasync.service.encrypt.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.es.esservice.IOrigiCipIdEsService;
import cn.smarthse.es.model.OrigiCipIdModel;
import cn.smarthse.es.model.OrigiCipIdParamModel;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.services.datasync.dao.encrypt.NeedEncryptFieldMapper;
import cn.smarthse.services.datasync.pojo.model.NeedEncryptFieldParam;
import cn.smarthse.services.datasync.pojo.model.UpdateEncryptFieldDto;
import cn.smarthse.services.datasync.pojo.vo.NeedEncryptFieldVo;
import cn.smarthse.services.datasync.service.encrypt.ICryptoService;
import cn.smarthse.services.datasync.service.encrypt.INeedEncryptFieldService;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.context.XxlJobHelper;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionTemplate;

@DubboService
public class CryptoServiceImpl
implements ICryptoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CryptoServiceImpl.class);
    private static final Integer SDK_BATCH_SIZE = 2000;
    private static final Integer BATCH_SIZE = 10000;
    private static final Integer MYSQL_BATCH_SIZE = 100000;
    private static final Integer INNER_BATCH_SIZE = 10;
    private static final Integer TABLE_JOIN_BATCH_SIZE = 20000;
    private static final long LOG_INTERVAL = 10000L;
    private static final int MAX_CONCURRENT_TASKS = 50;
    private static final String PREFIX = "VI*D#S";
    @Autowired(required=false)
    private FieldEncryptorProperties fieldEncryptionProperties;
    @Autowired(required=false)
    private EncryptorManager encryptorManager;
    private FieldEncryptorProperties.GroupConfig maxVersionGroupConfig;
    private EncryptContext encryptContext;
    private final Semaphore concurrentSemaphore = new Semaphore(50);
    private final TransactionTemplate transactionTemplate;
    private final ThreadPoolExecutor threadPoolExecutor;
    @Autowired
    private NeedEncryptFieldMapper needEncryptFieldMapper;
    private final INeedEncryptFieldService needEncryptFieldService;
    @DubboReference
    IOrigiCipIdEsService origiCipIdEsService;

    @PostConstruct
    public void init() {
        this.initEncryptContext();
    }

    @Override
    public void setBooleanFlagValue(String ids, Integer i, Boolean b) {
        if (StrUtil.isBlank((CharSequence)ids) || i == null || b == null) {
            return;
        }
        this.needEncryptFieldService.setBooleanFlagValue(ids, i, b);
    }

    @Override
    public String encryptData(String encrypt) {
        if (StrUtil.isBlank((CharSequence)encrypt)) {
            return "";
        }
        return this.encryptorManager.encrypt(encrypt, this.encryptContext);
    }

    @Override
    public String decryptData(String decrypt) {
        if (StrUtil.isBlank((CharSequence)decrypt)) {
            return "";
        }
        return this.encryptorManager.decrypt(decrypt, this.encryptContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void esConvert(String plaintext) {
        int pageNum = 1;
        boolean hasMore = Boolean.TRUE;
        long totalProcessed = 0L;
        Long totalCount = this.origiCipIdEsService.count();
        int totalBatches = (int)Math.ceil((double)totalCount.longValue() / (double)BATCH_SIZE.intValue());
        XxlJobHelper.log((String)"\u5f00\u59cb\u8f6c\u6362\u6240\u6709\u660e\u6587ID\u4e3aSM4\u52a0\u5bc6\u683c\u5f0f::\u603b\u8bb0\u5f55\u6570{}", (Object[])new Object[]{StrUtil.isNotBlank((CharSequence)plaintext) ? 1L : totalCount});
        log.error("\u5f00\u59cb\u8f6c\u6362\u6240\u6709\u660e\u6587ID\u4e3aSM4\u52a0\u5bc6\u683c\u5f0f::\u603b\u8bb0\u5f55\u6570{}", (Object)totalCount);
        while (hasMore) {
            try {
                PageInfo esPage;
                List esList;
                OrigiCipIdParamModel param = new OrigiCipIdParamModel();
                if (StrUtil.isNotBlank((CharSequence)plaintext)) {
                    param.setOrgiDatas((List)ListUtil.toList((Object[])new String[]{plaintext}));
                }
                if (CollUtil.isEmpty((Collection)(esList = (esPage = this.origiCipIdEsService.pageByPlaintextList_base(param, 1, BATCH_SIZE.intValue(), Boolean.TRUE, Boolean.TRUE)).getList())) || pageNum > totalBatches) {
                    hasMore = false;
                    XxlJobHelper.log((String)"\u6240\u6709\u6570\u636e\u8f6c\u6362\u5b8c\u6210::\u5171\u5904\u7406{}\u9875::\u603b\u8ba1{}\u6761\u6570\u636e::\u8fdb\u5ea6100%", (Object[])new Object[]{pageNum - 1, totalProcessed});
                    log.error("\u6240\u6709\u6570\u636e\u8f6c\u6362\u5b8c\u6210::\u5171\u5904\u7406{}\u9875::\u603b\u8ba1{}\u6761\u6570\u636e::\u8fdb\u5ea6100%", (Object)(pageNum - 1), (Object)totalProcessed);
                    break;
                }
                ArrayList<String> idsToDelete = new ArrayList<String>();
                ArrayList<OrigiCipIdModel> modelsToSave = new ArrayList<OrigiCipIdModel>();
                int batchCount = 0;
                for (OrigiCipIdModel es : esList) {
                    String esId = es.getOrgiData();
                    if (!CharSequenceUtil.isNotBlank((CharSequence)esId) || this.isAlreadyEncrypted(esId)) continue;
                    try {
                        String esIdSM4 = EncryptUtils.encryptBySm4((String)esId, (String)this.encryptContext.getPassword());
                        idsToDelete.add(es.getOrgiData());
                        OrigiCipIdModel encryptedModel = new OrigiCipIdModel();
                        BeanUtils.copyProperties((Object)es, (Object)encryptedModel);
                        encryptedModel.setOrgiData(esIdSM4);
                        encryptedModel.setIsIdConverted(Boolean.TRUE);
                        encryptedModel.setUpdateDate(new Date());
                        modelsToSave.add(encryptedModel);
                        ++batchCount;
                        ++totalProcessed;
                    }
                    catch (Exception e) {
                        XxlJobHelper.log((String)"\u52a0\u5bc6\u5931\u8d25::\u539f\u59cb\u6570\u636e{}::\u9519\u8bef{}", (Object[])new Object[]{esId, e.getMessage()});
                        log.error("\u52a0\u5bc6\u5931\u8d25::\u539f\u59cb\u6570\u636e{}::\u9519\u8bef{}", (Object)esId, (Object)e.getMessage());
                    }
                }
                if (batchCount > 0) {
                    this.origiCipIdEsService.executeBatchOperation(idsToDelete, modelsToSave);
                    long process = totalProcessed * 100L / totalCount;
                    XxlJobHelper.log((String)"\u7b2c{}\u6279\u5904\u7406\u5b8c\u6210::\u6210\u529f\u52a0\u5bc6{}\u6761\u6570\u636e::\u603b\u8ba1\u5df2\u5904\u7406{}::\u8fdb\u5ea6{}%", (Object[])new Object[]{pageNum, batchCount, totalProcessed, process});
                    log.error("\u7b2c{}\u6279\u5904\u7406\u5b8c\u6210::\u6210\u529f\u52a0\u5bc6{}\u6761\u6570\u636e::\u603b\u8ba1\u5df2\u5904\u7406{}::\u8fdb\u5ea6{}%", new Object[]{pageNum, batchCount, totalProcessed, process});
                    continue;
                }
                long progress = totalProcessed * 100L / totalCount;
                XxlJobHelper.log((String)"\u7b2c{}\u6279\u65e0\u9700\u8981\u5904\u7406\u7684\u6570\u636e::\u8fdb\u5ea6{}%", (Object[])new Object[]{pageNum, progress});
                log.error("\u7b2c{}\u6279\u65e0\u9700\u8981\u5904\u7406\u7684\u6570\u636e::\u8fdb\u5ea6{}%", (Object)pageNum, (Object)progress);
            }
            catch (Exception e) {
                long progress = totalProcessed * 100L / totalCount;
                XxlJobHelper.log((String)"\u7b2c{}\u6279\u5904\u7406\u5931\u8d25::{}::\u5f53\u524d\u8fdb\u5ea6{}%", (Object[])new Object[]{pageNum, e.getMessage(), progress});
                log.error("\u7b2c{}\u6279\u5904\u7406\u5931\u8d25::{}::\u5f53\u524d\u8fdb\u5ea6{}%", new Object[]{pageNum, e.getMessage(), progress, e});
            }
            finally {
                ++pageNum;
            }
        }
        XxlJobHelper.log((String)"\u6240\u6709\u6570\u636e\u8f6c\u6362\u5b8c\u6210::\u603b\u8ba1\u5904\u7406{}\u6761\u6570\u636e", (Object[])new Object[]{totalProcessed});
        log.error("\u6240\u6709\u6570\u636e\u8f6c\u6362\u5b8c\u6210::\u603b\u8ba1\u5904\u7406{}\u6761\u6570\u636e", (Object)totalProcessed);
    }

    private boolean isAlreadyEncrypted(String esId) {
        try {
            String tryDecryptValue = EncryptUtils.decryptBySm4((String)esId, (String)this.encryptContext.getPassword());
            return CharSequenceUtil.isNotBlank((CharSequence)tryDecryptValue);
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    @Override
    public void encryptToEs(NeedEncryptFieldParam param) {
        long startTime = System.currentTimeMillis();
        if (param == null) {
            param = new NeedEncryptFieldParam();
        }
        Boolean hg = param.getHg();
        List<NeedEncryptFieldVo> needEsEncryptFieldList = this.needEncryptFieldService.getNeedEsEncryptFieldList(param);
        boolean doBatch = "batch".equalsIgnoreCase(param.getRemark());
        if (CollUtil.isEmpty(needEsEncryptFieldList)) {
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u6ca1\u6709\u6570\u636e\u5217\u9700\u52a0\u5bc6\u5b58\u5165ES", (Object[])new Object[0]);
            log.error("\u65e5\u5fd7\u6253\u5370::\u6ca1\u6709\u6570\u636e\u5217\u9700\u52a0\u5bc6\u5b58\u5165ES");
            return;
        }
        CountDownLatch latch = new CountDownLatch(needEsEncryptFieldList.size());
        needEsEncryptFieldList.forEach(vo -> this.threadPoolExecutor.execute(new XxlJobLogRunnable(() -> {
            try {
                this.concurrentSemaphore.acquire();
                NeedEncryptFieldParam fieldParam = new NeedEncryptFieldParam();
                BeanUtils.copyProperties((Object)vo, (Object)fieldParam);
                fieldParam.setHg(hg);
                if (doBatch) {
                    this.processEncryptValueToEsBatch(fieldParam);
                } else {
                    this.processEncryptValueToEs(fieldParam);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::\u5bc6\u6587\u5b58\u5165ES\uff0c\u53d1\u751f\u4e2d\u65ad\u3002", (Object[])new Object[]{e});
                log.error("\u5f02\u5e38\u6253\u5370::\u5bc6\u6587\u5b58\u5165ES\uff0c\u53d1\u751f\u4e2d\u65ad\u3002", (Throwable)e);
            }
            catch (Exception e) {
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::\u5bc6\u6587\u5b58\u5165ES\uff0c\u53d1\u751f\u5f02\u5e38\u3002", (Object[])new Object[]{e});
                log.error("\u5f02\u5e38\u6253\u5370::\u5bc6\u6587\u5b58\u5165ES\uff0c\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            }
            finally {
                this.concurrentSemaphore.release();
                latch.countDown();
            }
        })));
        try {
            latch.await();
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u6240\u6709\u5b57\u6bb5\u503c\u5747\u5df2\u8f6c\u4e3a\u5bc6\u6587\u5e76\u5b58\u5165ES::\u603b\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{System.currentTimeMillis() - startTime});
            log.error("\u65e5\u5fd7\u6253\u5370::\u6240\u6709\u5b57\u6bb5\u503c\u5747\u5df2\u8f6c\u4e3a\u5bc6\u6587\u5e76\u5b58\u5165ES::\u603b\u8017\u65f6[{}]\u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("\u5bc6\u6587\u5b58\u5165ES\u4e2d\u65ad", e);
        }
    }

    @Override
    public void encryptToBusiness(NeedEncryptFieldParam param) {
        long startTime = System.currentTimeMillis();
        if (param == null) {
            param = new NeedEncryptFieldParam();
        }
        Boolean hg = param.getHg();
        List<NeedEncryptFieldVo> needBusinessEncryptFieldList = this.needEncryptFieldService.getNeedBusinessEncryptFieldList(param);
        boolean doBatch = "batch".equalsIgnoreCase(param.getRemark());
        if (CollUtil.isEmpty(needBusinessEncryptFieldList)) {
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u6ca1\u6709\u9700\u8981\u52a0\u5bc6\u7684\u5b57\u6bb5", (Object[])new Object[0]);
            log.error("\u65e5\u5fd7\u6253\u5370::\u6ca1\u6709\u9700\u8981\u52a0\u5bc6\u7684\u5b57\u6bb5");
            return;
        }
        CountDownLatch latch = new CountDownLatch(needBusinessEncryptFieldList.size());
        needBusinessEncryptFieldList.forEach(vo -> this.threadPoolExecutor.execute(new XxlJobLogRunnable(() -> {
            try {
                this.concurrentSemaphore.acquire();
                NeedEncryptFieldParam fieldParam = new NeedEncryptFieldParam();
                BeanUtils.copyProperties((Object)vo, (Object)fieldParam);
                fieldParam.setHg(hg);
                if (doBatch) {
                    this.processEncryptValueToTempBatch(fieldParam);
                } else {
                    this.processEncryptValueToTemp(fieldParam);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::\u52a0\u5bc6\u5904\u7406\u4e2d\u65ad", (Object[])new Object[]{e});
                log.error("\u5f02\u5e38\u6253\u5370::\u52a0\u5bc6\u5904\u7406\u4e2d\u65ad", (Throwable)e);
            }
            catch (Exception e) {
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::\u52a0\u5bc6\u5904\u7406\u5f02\u5e38", (Object[])new Object[]{e});
                log.error("\u5f02\u5e38\u6253\u5370::\u52a0\u5bc6\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.concurrentSemaphore.release();
                latch.countDown();
            }
        })));
        try {
            latch.await();
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u6240\u6709\u5b57\u6bb5\u5747\u5df2\u52a0\u5bc6\u5b8c\u6210::\u603b\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{System.currentTimeMillis() - startTime});
            log.error("\u65e5\u5fd7\u6253\u5370::\u6240\u6709\u5b57\u6bb5\u5747\u5df2\u52a0\u5bc6\u5b8c\u6210::\u603b\u8017\u65f6[{}]\u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("\u52a0\u5bc6\u5904\u7406\u4e2d\u65ad", e);
        }
    }

    @Override
    public void decryptToBusiness(NeedEncryptFieldParam param) {
        long startTime = System.currentTimeMillis();
        if (param == null) {
            param = new NeedEncryptFieldParam();
        }
        Boolean hg = param.getHg();
        List<NeedEncryptFieldVo> needBusinessEncryptFieldList = this.needEncryptFieldService.getNeedBusinessDecryptFieldList(param);
        boolean doBatch = "batch".equalsIgnoreCase(param.getRemark());
        if (CollUtil.isEmpty(needBusinessEncryptFieldList)) {
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u6ca1\u6709\u9700\u8981\u89e3\u5bc6\u7684\u5b57\u6bb5", (Object[])new Object[0]);
            log.error("\u65e5\u5fd7\u6253\u5370::\u6ca1\u6709\u9700\u8981\u89e3\u5bc6\u7684\u5b57\u6bb5");
            return;
        }
        CountDownLatch latch = new CountDownLatch(needBusinessEncryptFieldList.size());
        needBusinessEncryptFieldList.forEach(vo -> this.threadPoolExecutor.execute(new XxlJobLogRunnable(() -> {
            try {
                this.concurrentSemaphore.acquire();
                NeedEncryptFieldParam fieldParam = new NeedEncryptFieldParam();
                BeanUtils.copyProperties((Object)vo, (Object)fieldParam);
                fieldParam.setHg(hg);
                if (doBatch) {
                } else {
                    this.processDecryptValueToTemp(fieldParam);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::\u89e3\u5bc6\u5904\u7406\u4e2d\u65ad", (Object[])new Object[]{e});
                log.error("\u5f02\u5e38\u6253\u5370::\u89e3\u5bc6\u5904\u7406\u4e2d\u65ad", (Throwable)e);
            }
            catch (Exception e) {
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::\u89e3\u5bc6\u5904\u7406\u5f02\u5e38", (Object[])new Object[]{e});
                log.error("\u5f02\u5e38\u6253\u5370::\u89e3\u5bc6\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.concurrentSemaphore.release();
                latch.countDown();
            }
        })));
        try {
            latch.await();
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u6240\u6709\u5b57\u6bb5\u5747\u5df2\u89e3\u5bc6\u5b8c\u6210::\u603b\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{System.currentTimeMillis() - startTime});
            log.error("\u65e5\u5fd7\u6253\u5370::\u6240\u6709\u5b57\u6bb5\u5747\u5df2\u89e3\u5bc6\u5b8c\u6210::\u603b\u8017\u65f6[{}]\u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("\u89e3\u5bc6\u5904\u7406\u4e2d\u65ad", e);
        }
    }

    public void processEncryptValueToEs(NeedEncryptFieldParam fieldParam) {
        long totalCount;
        long startTime;
        AtomicReference<Object> lastProcessedIdRef;
        AtomicLong errorCount;
        AtomicLong skippedCount;
        AtomicLong processedCount;
        AtomicLong selectedCount;
        String columnName;
        String tableName;
        String schemaName;
        block6: {
            CryptoServiceImpl.judgeSchemaTableColumn(fieldParam);
            schemaName = fieldParam.getSchemaName();
            tableName = fieldParam.getTableName();
            columnName = fieldParam.getColumnName();
            selectedCount = new AtomicLong(0L);
            processedCount = new AtomicLong(0L);
            skippedCount = new AtomicLong(0L);
            errorCount = new AtomicLong(0L);
            lastProcessedIdRef = new AtomicReference<Object>(null);
            startTime = System.currentTimeMillis();
            fieldParam.setEncryptPrefix(PREFIX);
            totalCount = this.needEncryptFieldService.count(fieldParam);
            if (totalCount != 0L) break block6;
            fieldParam.setEsEncrypt(Boolean.TRUE);
            this.needEncryptFieldService.putFlag(fieldParam);
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u52a0\u5bc6\u5b58\u5165ES\u7684\u6570\u636e", (Object[])new Object[]{schemaName, tableName, columnName});
            log.error("\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u52a0\u5bc6\u5b58\u5165ES\u7684\u6570\u636e", new Object[]{schemaName, tableName, columnName});
            long totalMillis = System.currentTimeMillis() - startTime;
            XxlJobHelper.log((String)"----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            log.error("----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            return;
        }
        try {
            boolean hasMore;
            while (hasMore = Boolean.TRUE.equals(this.transactionTemplate.execute(status -> {
                fieldParam.setLastPkValue((Long)lastProcessedIdRef.get());
                fieldParam.setLimit(SDK_BATCH_SIZE);
                try {
                    long l1 = System.currentTimeMillis();
                    List<NeedEncryptFieldVo> rowList = this.needEncryptFieldService.batchSelectColumnValueList(fieldParam);
                    if (CollUtil.isEmpty(rowList)) {
                        return Boolean.FALSE;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = System.currentTimeMillis();
                    List<String> originalList = rowList.stream().map(NeedEncryptFieldVo::getColumnValue).toList();
                    OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
                    originalList = originalList.stream().map(String::trim).map(s -> fieldParam.getNeedUpper() != false ? CharSequenceUtil.toUpperCase((CharSequence)s) : s).map(s -> EncryptUtils.encryptBySm4((String)s, (String)this.encryptContext.getPassword())).toList();
                    esParam.setOrgiDatas(originalList);
                    PageInfo origiModelPage = this.origiCipIdEsService.pageByPlaintextList(esParam, 1, SDK_BATCH_SIZE.intValue());
                    List origiModelList = origiModelPage == null || origiModelPage.getList() == null ? Collections.emptyList() : origiModelPage.getList();
                    Map<String, OrigiCipIdModel> origiMap = origiModelList.stream().filter(m -> m != null && m.getOrgiData() != null).collect(Collectors.toMap(OrigiCipIdModel::getOrgiData, m -> m, (a, b) -> a));
                    List<OrigiCipIdModel> putToEsList = rowList.stream().map(row -> {
                        Long pkValue = row.getPkValue();
                        String columnValue = row.getColumnValue();
                        if (fieldParam.getNeedUpper().booleanValue()) {
                            columnValue = CharSequenceUtil.toUpperCase((CharSequence)columnValue);
                        }
                        try {
                            String columnValueSM4 = EncryptUtils.encryptBySm4((String)columnValue, (String)this.encryptContext.getPassword());
                            OrigiCipIdModel nowEsModel = (OrigiCipIdModel)origiMap.get(columnValueSM4);
                            if (nowEsModel == null || nowEsModel.getCipData() == null) {
                                String encryptedValue = this.encryptorManager.encrypt(columnValue, this.encryptContext);
                                OrigiCipIdModel saveEsModel = new OrigiCipIdModel();
                                saveEsModel.setOrgiData(columnValueSM4);
                                saveEsModel.setCipData(encryptedValue);
                                return saveEsModel;
                            }
                            return null;
                        }
                        catch (Exception e) {
                            errorCount.incrementAndGet();
                            XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636eES\u52a0\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", (Object[])new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                            log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636eES\u52a0\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                            return null;
                        }
                    }).filter(Objects::nonNull).toList();
                    long l4 = System.currentTimeMillis();
                    long t1 = l2 - l1;
                    long t2 = l4 - l3;
                    long currentSelected = selectedCount.addAndGet(rowList.size());
                    if (CollUtil.isNotEmpty(putToEsList)) {
                        long l5 = System.currentTimeMillis();
                        this.origiCipIdEsService.batchSave(putToEsList);
                        long l6 = System.currentTimeMillis();
                        long currentProcessed = processedCount.addAndGet(putToEsList.size());
                        long t3 = l6 - l5;
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::ES\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, t3, currentSelected, totalCount, currentSelected * 100L / totalCount});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::ES\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, t3, currentSelected, totalCount, currentSelected * 100L / totalCount});
                    } else {
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u5728ES\u52a0\u5bc6,\u65e0\u64cd\u4f5c::ES\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), SDK_BATCH_SIZE, currentSelected, totalCount, currentSelected * 100L / totalCount});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u5728ES\u52a0\u5bc6,\u65e0\u64cd\u4f5c::ES\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), SDK_BATCH_SIZE, currentSelected, totalCount, currentSelected * 100L / totalCount});
                    }
                    lastProcessedIdRef.set(rowList.get(rowList.size() - 1).getPkValue());
                    return rowList.size() >= SDK_BATCH_SIZE;
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    errorCount.incrementAndGet();
                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5bc6\u6587\u5b58\u5165ES\u5931\u8d25::\u6279\u6b21({},+{}]\u51fa\u9519", (Object[])new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), SDK_BATCH_SIZE, e});
                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5bc6\u6587\u5b58\u5165ES\u5931\u8d25::\u6279\u6b21({},+{}]\u51fa\u9519", new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), SDK_BATCH_SIZE, e});
                    throw new RuntimeException("\u5bc6\u6587\u5b58\u5165ES\u5931\u8d25", e);
                }
            }))) {
            }
            fieldParam.setEsEncrypt(Boolean.TRUE);
            this.needEncryptFieldService.putFlag(fieldParam);
        }
        catch (Exception e) {
            try {
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5bc6\u6587\u5b58\u5165ES\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", (Object[])new Object[]{schemaName, tableName, columnName, e});
                log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5bc6\u6587\u5b58\u5165ES\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", new Object[]{schemaName, tableName, columnName, e});
                throw new RuntimeException("\u5bc6\u6587\u5b58\u5165ES\u8fc7\u7a0b\u4e2d\u65ad", e);
            }
            catch (Throwable throwable) {
                long totalMillis = System.currentTimeMillis() - startTime;
                XxlJobHelper.log((String)"----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                log.error("----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                throw throwable;
            }
        }
        long totalMillis = System.currentTimeMillis() - startTime;
        XxlJobHelper.log((String)"----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
        log.error("----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
    }

    public void processEncryptValueToEsBatch(NeedEncryptFieldParam fieldParam) {
        long totalCount;
        long startTime;
        AtomicReference<Object> lastProcessedIdRef;
        AtomicLong errorCount;
        AtomicLong skippedCount;
        AtomicLong processedCount;
        AtomicLong selectedCount;
        String columnName;
        String tableName;
        String schemaName;
        block6: {
            CryptoServiceImpl.judgeSchemaTableColumn(fieldParam);
            schemaName = fieldParam.getSchemaName();
            tableName = fieldParam.getTableName();
            columnName = fieldParam.getColumnName();
            selectedCount = new AtomicLong(0L);
            processedCount = new AtomicLong(0L);
            skippedCount = new AtomicLong(0L);
            errorCount = new AtomicLong(0L);
            lastProcessedIdRef = new AtomicReference<Object>(null);
            startTime = System.currentTimeMillis();
            fieldParam.setEncryptPrefix(PREFIX);
            totalCount = this.needEncryptFieldService.count(fieldParam);
            if (totalCount != 0L) break block6;
            fieldParam.setEsEncrypt(Boolean.TRUE);
            this.needEncryptFieldService.putFlag(fieldParam);
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u52a0\u5bc6\u5b58\u5165ES\u7684\u6570\u636e", (Object[])new Object[]{schemaName, tableName, columnName});
            log.error("\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u52a0\u5bc6\u5b58\u5165ES\u7684\u6570\u636e", new Object[]{schemaName, tableName, columnName});
            long totalMillis = System.currentTimeMillis() - startTime;
            XxlJobHelper.log((String)"----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            log.error("----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            return;
        }
        try {
            boolean hasMore;
            while (hasMore = Boolean.TRUE.equals(this.transactionTemplate.execute(status -> {
                fieldParam.setLastPkValue((Long)lastProcessedIdRef.get());
                fieldParam.setLimit(MYSQL_BATCH_SIZE);
                ExecutorService innerExecutor = Executors.newFixedThreadPool(INNER_BATCH_SIZE);
                ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
                try {
                    long l1 = System.currentTimeMillis();
                    List<NeedEncryptFieldVo> mysqlRowList = this.needEncryptFieldService.batchSelectColumnValueList(fieldParam);
                    if (CollUtil.isEmpty(mysqlRowList)) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = System.currentTimeMillis();
                    List<List<NeedEncryptFieldVo>> dbPartitions = this.partitionList(mysqlRowList, INNER_BATCH_SIZE);
                    CountDownLatch esLatch = new CountDownLatch(dbPartitions.size());
                    ArrayList origiModelList = new ArrayList();
                    for (List<NeedEncryptFieldVo> partition : dbPartitions) {
                        innerExecutor.execute(() -> {
                            try {
                                List<String> partOriginalList = partition.stream().map(NeedEncryptFieldVo::getColumnValue).toList();
                                OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
                                partOriginalList = partOriginalList.stream().map(String::trim).map(s -> fieldParam.getNeedUpper() != false ? CharSequenceUtil.toUpperCase((CharSequence)s) : s).map(s -> EncryptUtils.encryptBySm4((String)s, (String)this.encryptContext.getPassword())).toList();
                                esParam.setOrgiDatas(partOriginalList);
                                PageInfo partPage = this.origiCipIdEsService.pageByPlaintextList(esParam, 1, BATCH_SIZE.intValue());
                                List partList = partPage == null || partPage.getList() == null ? Collections.emptyList() : partPage.getList();
                                origiModelList.addAll(partList);
                            }
                            catch (Exception e) {
                                log.error("\u67e5\u8be2es\u5f02\u5e38::", (Throwable)e);
                            }
                            finally {
                                esLatch.countDown();
                            }
                        });
                    }
                    try {
                        esLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    Map<String, OrigiCipIdModel> origiMap = origiModelList.stream().filter(m -> m != null && m.getOrgiData() != null).collect(Collectors.toMap(OrigiCipIdModel::getOrgiData, m -> m, (a, b) -> a));
                    for (int i = 0; i < dbPartitions.size(); ++i) {
                        int batchIndex = i;
                        List<NeedEncryptFieldVo> list = dbPartitions.get(i);
                        if (CollUtil.isEmpty(list)) continue;
                        futures.add(innerExecutor.submit(() -> {
                            ArrayList<OrigiCipIdModel> batchEsList = new ArrayList<OrigiCipIdModel>();
                            for (NeedEncryptFieldVo row : rowList) {
                                Long pkValue = row.getPkValue();
                                String columnValue = row.getColumnValue();
                                if (fieldParam.getNeedUpper().booleanValue()) {
                                    columnValue = CharSequenceUtil.toUpperCase((CharSequence)columnValue);
                                }
                                try {
                                    String columnValueSM4;
                                    OrigiCipIdModel nowEsModel;
                                    if (!CharSequenceUtil.isNotBlank((CharSequence)columnValue) || columnValue.startsWith(PREFIX) || (nowEsModel = (OrigiCipIdModel)origiMap.get(columnValueSM4 = EncryptUtils.encryptBySm4((String)columnValue, (String)this.encryptContext.getPassword()))) != null && nowEsModel.getCipData() != null) continue;
                                    String encryptedValue = this.encryptorManager.encrypt(columnValue, this.encryptContext);
                                    OrigiCipIdModel saveEsModel = new OrigiCipIdModel();
                                    saveEsModel.setOrgiData(columnValueSM4);
                                    saveEsModel.setCipData(encryptedValue);
                                    batchEsList.add(saveEsModel);
                                }
                                catch (Exception e) {
                                    errorCount.incrementAndGet();
                                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636eES\u52a0\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", (Object[])new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636eES\u52a0\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                                }
                            }
                            return batchEsList;
                        }));
                    }
                    ArrayList putToEsList = new ArrayList();
                    for (Future future : futures) {
                        try {
                            List batchResult = (List)future.get();
                            if (batchResult == null) continue;
                            putToEsList.addAll(batchResult);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            errorCount.incrementAndGet();
                            XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5e76\u884c\u52a0\u5bc6\u5904\u7406\u5931\u8d25", (Object[])new Object[]{schemaName, tableName, columnName, e});
                            log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5e76\u884c\u52a0\u5bc6\u5904\u7406\u5931\u8d25", new Object[]{schemaName, tableName, columnName, e});
                        }
                    }
                    long l4 = System.currentTimeMillis();
                    long t1 = l2 - l1;
                    long t2 = l4 - l3;
                    long currentSelected = selectedCount.addAndGet(mysqlRowList.size());
                    if (CollUtil.isNotEmpty(putToEsList)) {
                        long l5 = System.currentTimeMillis();
                        List esPartitions = ListUtil.partition(putToEsList, (int)BATCH_SIZE);
                        CountDownLatch saveLatch = new CountDownLatch(esPartitions.size());
                        for (List esPartition : esPartitions) {
                            innerExecutor.execute(() -> {
                                try {
                                    this.origiCipIdEsService.batchSave(esPartition);
                                }
                                catch (Exception e) {
                                    log.error("\u5b58es\u5f02\u5e38::", (Throwable)e);
                                }
                                finally {
                                    saveLatch.countDown();
                                }
                            });
                        }
                        try {
                            saveLatch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        long l6 = System.currentTimeMillis();
                        long currentProcessed = processedCount.addAndGet(putToEsList.size());
                        long t3 = l6 - l5;
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::ES\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, t3, currentSelected, totalCount, currentSelected * 100L / totalCount});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::ES\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, t3, currentSelected, totalCount, currentSelected * 100L / totalCount});
                    } else {
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u5728ES\u52a0\u5bc6,\u65e0\u64cd\u4f5c::ES\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, currentSelected, totalCount, currentSelected * 100L / totalCount});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u5728ES\u52a0\u5bc6,\u65e0\u64cd\u4f5c::ES\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, currentSelected, totalCount, currentSelected * 100L / totalCount});
                    }
                    lastProcessedIdRef.set(mysqlRowList.get(mysqlRowList.size() - 1).getPkValue());
                    Boolean bl = mysqlRowList.size() >= MYSQL_BATCH_SIZE;
                    return bl;
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    errorCount.incrementAndGet();
                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5bc6\u6587\u5b58\u5165ES\u5931\u8d25::\u6279\u6b21({},+{}]\u51fa\u9519", (Object[])new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, e});
                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5bc6\u6587\u5b58\u5165ES\u5931\u8d25::\u6279\u6b21({},+{}]\u51fa\u9519", new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, e});
                    throw new RuntimeException("\u5bc6\u6587\u5b58\u5165ES\u5931\u8d25", e);
                }
                finally {
                    CryptoServiceImpl.shutdown(innerExecutor);
                }
            }))) {
            }
            fieldParam.setEsEncrypt(Boolean.TRUE);
            this.needEncryptFieldService.putFlag(fieldParam);
        }
        catch (Exception e) {
            try {
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5bc6\u6587\u5b58\u5165ES\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", (Object[])new Object[]{schemaName, tableName, columnName, e});
                log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5bc6\u6587\u5b58\u5165ES\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", new Object[]{schemaName, tableName, columnName, e});
                throw new RuntimeException("\u5bc6\u6587\u5b58\u5165ES\u8fc7\u7a0b\u4e2d\u65ad", e);
            }
            catch (Throwable throwable) {
                long totalMillis = System.currentTimeMillis() - startTime;
                XxlJobHelper.log((String)"----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                log.error("----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                throw throwable;
            }
        }
        long totalMillis = System.currentTimeMillis() - startTime;
        XxlJobHelper.log((String)"----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
        log.error("----------> \u2705 \u5bc6\u6587\u5b58\u5165ES\u5b8c\u6bd5::[{}.{}.{}]::\u626b\u63cf[{}]\u5904\u7406[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6{}\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, selectedCount.get(), processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
    }

    public void processEncryptValueToTemp(NeedEncryptFieldParam fieldParam) {
        long totalCount;
        long startTime;
        AtomicReference<Object> lastProcessedIdRef;
        AtomicLong errorCount;
        AtomicLong skippedCount;
        AtomicLong processedCount;
        AtomicLong selectedCount;
        String columnName;
        String tableName;
        String schemaName;
        block6: {
            CryptoServiceImpl.judgeSchemaTableColumn(fieldParam);
            schemaName = fieldParam.getSchemaName();
            tableName = fieldParam.getTableName();
            columnName = fieldParam.getColumnName();
            selectedCount = new AtomicLong(0L);
            processedCount = new AtomicLong(0L);
            skippedCount = new AtomicLong(0L);
            errorCount = new AtomicLong(0L);
            lastProcessedIdRef = new AtomicReference<Object>(null);
            startTime = System.currentTimeMillis();
            List<Long> cidList = fieldParam.getHg() != null ? this.needEncryptFieldService.getHgCidList() : null;
            fieldParam.setCidList(cidList);
            fieldParam.setEncryptPrefix(PREFIX);
            totalCount = this.needEncryptFieldService.count(fieldParam);
            if (totalCount != 0L) break block6;
            fieldParam.setEncryptFlag(Boolean.TRUE);
            fieldParam.setDecryptFlag(Boolean.FALSE);
            this.needEncryptFieldService.putFlag(fieldParam);
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u8981\u52a0\u5bc6\u7684\u6570\u636e", (Object[])new Object[]{schemaName, tableName, columnName});
            log.error("\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u8981\u52a0\u5bc6\u7684\u6570\u636e", new Object[]{schemaName, tableName, columnName});
            this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
            long totalMillis = System.currentTimeMillis() - startTime;
            XxlJobHelper.log((String)"----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            log.error("----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            return;
        }
        try {
            boolean hasMore;
            fieldParam.setTempPrefix("en_");
            this.needEncryptFieldService.createTempEncryptTable(fieldParam);
            while (hasMore = Boolean.TRUE.equals(this.transactionTemplate.execute(status -> {
                fieldParam.setLastPkValue((Long)lastProcessedIdRef.get());
                fieldParam.setLimit(BATCH_SIZE);
                try {
                    long l1 = System.currentTimeMillis();
                    List<NeedEncryptFieldVo> rowList = this.needEncryptFieldService.batchSelectColumnValueList(fieldParam);
                    if (CollUtil.isEmpty(rowList)) {
                        return Boolean.FALSE;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = System.currentTimeMillis();
                    List<String> originalList = rowList.stream().map(NeedEncryptFieldVo::getColumnValue).toList();
                    OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
                    originalList = originalList.stream().map(String::trim).map(s -> fieldParam.getNeedUpper() != false ? CharSequenceUtil.toUpperCase((CharSequence)s) : s).map(s -> EncryptUtils.encryptBySm4((String)s, (String)this.encryptContext.getPassword())).toList();
                    esParam.setOrgiDatas(originalList);
                    PageInfo origiModelPage = this.origiCipIdEsService.pageByPlaintextList(esParam, 1, BATCH_SIZE.intValue());
                    List origiModelList = origiModelPage == null || origiModelPage.getList() == null ? Collections.emptyList() : origiModelPage.getList();
                    Map<String, OrigiCipIdModel> origiMap = origiModelList.stream().filter(m -> m != null && m.getOrgiData() != null).collect(Collectors.toMap(OrigiCipIdModel::getOrgiData, m -> m, (a, b) -> a));
                    List<UpdateEncryptFieldDto> updateList = rowList.stream().map(row -> {
                        Long pkValue = row.getPkValue();
                        String columnValue = row.getColumnValue();
                        if (fieldParam.getNeedUpper().booleanValue()) {
                            columnValue = CharSequenceUtil.toUpperCase((CharSequence)columnValue);
                        }
                        try {
                            String columnValueSM4 = EncryptUtils.encryptBySm4((String)columnValue, (String)this.encryptContext.getPassword());
                            OrigiCipIdModel model = (OrigiCipIdModel)origiMap.get(columnValueSM4);
                            String encryptedValue = model == null || model.getCipData() == null ? this.encryptorManager.encrypt(columnValue, this.encryptContext) : model.getCipData();
                            return new UpdateEncryptFieldDto(pkValue, encryptedValue);
                        }
                        catch (Exception e) {
                            errorCount.incrementAndGet();
                            XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", (Object[])new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                            log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                            return null;
                        }
                    }).filter(Objects::nonNull).toList();
                    long l4 = System.currentTimeMillis();
                    long t1 = l2 - l1;
                    long t2 = l4 - l3;
                    long currentSelected = selectedCount.addAndGet(rowList.size());
                    long process = currentSelected * 100L / totalCount;
                    if (CollUtil.isNotEmpty(updateList)) {
                        long l5 = System.currentTimeMillis();
                        this.needEncryptFieldService.batchInsertToTempTable(updateList, fieldParam);
                        long l6 = System.currentTimeMillis();
                        long currentProcessed = processedCount.addAndGet(updateList.size());
                        long t3 = l6 - l5;
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, t3, currentSelected, totalCount, process});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, t3, currentSelected, totalCount, process});
                    } else {
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u52a0\u5bc6,\u65e0\u64cd\u4f5c::\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), BATCH_SIZE, currentSelected, totalCount, process});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u52a0\u5bc6,\u65e0\u64cd\u4f5c::\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), BATCH_SIZE, currentSelected, totalCount, process});
                    }
                    lastProcessedIdRef.set(rowList.get(rowList.size() - 1).getPkValue());
                    return rowList.size() >= BATCH_SIZE;
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    errorCount.incrementAndGet();
                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u6279\u6b21({},+{}]\u51fa\u9519::\u52a0\u5bc6\u5931\u8d25\uff01", (Object[])new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), BATCH_SIZE, e});
                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u6279\u6b21({},+{}]\u51fa\u9519::\u4e1a\u52a1\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff01", new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), BATCH_SIZE, e});
                    throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u52a0\u5bc6\u5931\u8d25", e);
                }
            }))) {
            }
            this.processValueToBusiness(fieldParam);
            fieldParam.setEncryptFlag(Boolean.TRUE);
            fieldParam.setDecryptFlag(Boolean.FALSE);
            this.needEncryptFieldService.putFlag(fieldParam);
            this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
        }
        catch (Exception e) {
            try {
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u52a0\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", (Object[])new Object[]{schemaName, tableName, columnName, e});
                log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u52a0\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", new Object[]{schemaName, tableName, columnName, e});
                throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u52a0\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u65ad", e);
            }
            catch (Throwable throwable) {
                this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
                long totalMillis = System.currentTimeMillis() - startTime;
                XxlJobHelper.log((String)"----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                log.error("----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                throw throwable;
            }
        }
        long totalMillis = System.currentTimeMillis() - startTime;
        XxlJobHelper.log((String)"----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
        log.error("----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
    }

    public void processDecryptValueToTemp(NeedEncryptFieldParam fieldParam) {
        long totalCount;
        long startTime;
        AtomicReference<Object> lastProcessedIdRef;
        AtomicLong sdkCnt;
        AtomicLong esCnt;
        AtomicLong errorCount;
        AtomicLong skippedCount;
        AtomicLong processedCount;
        AtomicLong selectedCount;
        String columnName;
        String tableName;
        String schemaName;
        block6: {
            CryptoServiceImpl.judgeSchemaTableColumn(fieldParam);
            schemaName = fieldParam.getSchemaName();
            tableName = fieldParam.getTableName();
            columnName = fieldParam.getColumnName();
            selectedCount = new AtomicLong(0L);
            processedCount = new AtomicLong(0L);
            skippedCount = new AtomicLong(0L);
            errorCount = new AtomicLong(0L);
            esCnt = new AtomicLong(0L);
            sdkCnt = new AtomicLong(0L);
            lastProcessedIdRef = new AtomicReference<Object>(null);
            startTime = System.currentTimeMillis();
            List<Long> cidList = fieldParam.getHg() != null ? this.needEncryptFieldService.getHgCidList() : null;
            fieldParam.setCidList(cidList);
            fieldParam.setEncryptPrefix(PREFIX);
            totalCount = this.needEncryptFieldService.count(fieldParam);
            if (totalCount != 0L) break block6;
            fieldParam.setEncryptFlag(Boolean.FALSE);
            fieldParam.setDecryptFlag(Boolean.TRUE);
            this.needEncryptFieldService.putFlag(fieldParam);
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u8981\u89e3\u5bc6\u7684\u6570\u636e", (Object[])new Object[]{schemaName, tableName, columnName});
            log.error("\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u8981\u89e3\u5bc6\u7684\u6570\u636e", new Object[]{schemaName, tableName, columnName});
            this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
            long totalMillis = System.currentTimeMillis() - startTime;
            XxlJobHelper.log((String)"----------> \u2705 \u89e3\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            log.error("----------> \u2705 \u89e3\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            return;
        }
        try {
            boolean hasMore;
            fieldParam.setTempPrefix("de_");
            this.needEncryptFieldService.createTempEncryptTable(fieldParam);
            while (hasMore = Boolean.TRUE.equals(this.transactionTemplate.execute(status -> {
                fieldParam.setLastPkValue((Long)lastProcessedIdRef.get());
                fieldParam.setLimit(BATCH_SIZE);
                try {
                    long l1 = System.currentTimeMillis();
                    List<NeedEncryptFieldVo> rowList = this.needEncryptFieldService.batchSelectColumnValueList(fieldParam);
                    if (CollUtil.isEmpty(rowList)) {
                        return Boolean.FALSE;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = System.currentTimeMillis();
                    List<String> cipDataList = rowList.stream().filter(row -> CharSequenceUtil.isNotBlank((CharSequence)row.getColumnValue()) && row.getColumnValue().startsWith(PREFIX)).map(NeedEncryptFieldVo::getColumnValue).toList();
                    OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
                    esParam.setCipDatas(cipDataList);
                    PageInfo cipModelPage = this.origiCipIdEsService.pageByCiphertextList(esParam, 1, BATCH_SIZE.intValue(), Boolean.TRUE);
                    List cipModelList = cipModelPage == null || cipModelPage.getList() == null ? Collections.emptyList() : cipModelPage.getList();
                    int esReturnValueSize = cipModelList.size();
                    Map<String, OrigiCipIdModel> cipMap = cipModelList.stream().filter(m -> m != null && m.getCipData() != null).collect(Collectors.toMap(OrigiCipIdModel::getCipData, m -> m, (a, b) -> a));
                    List<UpdateEncryptFieldDto> updateList = rowList.stream().filter(row -> CharSequenceUtil.isNotBlank((CharSequence)row.getColumnValue()) && row.getColumnValue().startsWith(PREFIX)).map(row -> {
                        Long pkValue = row.getPkValue();
                        String columnValue = row.getColumnValue();
                        try {
                            String decryptedValue;
                            OrigiCipIdModel model = (OrigiCipIdModel)cipMap.get(columnValue);
                            if (model == null || model.getOrgiData() == null) {
                                decryptedValue = this.encryptorManager.decrypt(columnValue, this.encryptContext);
                                sdkCnt.incrementAndGet();
                            } else {
                                String esValueSM4 = model.getOrgiData();
                                decryptedValue = EncryptUtils.decryptBySm4((String)esValueSM4, (String)this.encryptContext.getPassword());
                                esCnt.incrementAndGet();
                            }
                            return new UpdateEncryptFieldDto(pkValue, decryptedValue);
                        }
                        catch (Exception e) {
                            errorCount.incrementAndGet();
                            XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", (Object[])new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                            log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                            return null;
                        }
                    }).filter(Objects::nonNull).toList();
                    long l4 = System.currentTimeMillis();
                    long t1 = l2 - l1;
                    long t2 = l4 - l3;
                    long currentSelected = selectedCount.addAndGet(rowList.size());
                    long process = currentSelected * 100L / totalCount;
                    if (CollUtil.isNotEmpty(updateList)) {
                        long l5 = System.currentTimeMillis();
                        this.needEncryptFieldService.batchInsertToTempTable(updateList, fieldParam);
                        long l6 = System.currentTimeMillis();
                        long currentProcessed = processedCount.addAndGet(updateList.size());
                        long t3 = l6 - l5;
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u89e3\u5bc6[{}/{},{}]::\u89e3\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, t3, esCnt, esReturnValueSize, sdkCnt, currentSelected, totalCount, process});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u89e3\u5bc6[{}/{},{}]::\u89e3\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, t3, esCnt, esReturnValueSize, sdkCnt, currentSelected, totalCount, process});
                    } else {
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u89e3\u5bc6[{}/{},{}]::\u6279\u6b21({},+{}]\u5df2\u89e3\u5bc6,\u65e0\u64cd\u4f5c::\u89e3\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, 0L, esCnt, esReturnValueSize, sdkCnt, fieldParam.getLastPkValue(), BATCH_SIZE, currentSelected, totalCount, process});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u89e3\u5bc6,\u65e0\u64cd\u4f5c::\u89e3\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), BATCH_SIZE, currentSelected, totalCount, process});
                    }
                    lastProcessedIdRef.set(rowList.get(rowList.size() - 1).getPkValue());
                    return rowList.size() >= BATCH_SIZE;
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    errorCount.incrementAndGet();
                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u6279\u6b21({},+{}]\u51fa\u9519::\u89e3\u5bc6\u5931\u8d25\uff01", (Object[])new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), BATCH_SIZE, e});
                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u6279\u6b21({},+{}]\u51fa\u9519::\u4e1a\u52a1\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff01", new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), BATCH_SIZE, e});
                    throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u89e3\u5bc6\u5931\u8d25", e);
                }
            }))) {
            }
            this.processValueToBusiness(fieldParam);
            fieldParam.setEncryptFlag(Boolean.FALSE);
            fieldParam.setDecryptFlag(Boolean.TRUE);
            this.needEncryptFieldService.putFlag(fieldParam);
            this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
        }
        catch (Exception e) {
            try {
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u89e3\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", (Object[])new Object[]{schemaName, tableName, columnName, e});
                log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u89e3\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", new Object[]{schemaName, tableName, columnName, e});
                throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u89e3\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u65ad", e);
            }
            catch (Throwable throwable) {
                this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
                long totalMillis = System.currentTimeMillis() - startTime;
                XxlJobHelper.log((String)"----------> \u2705 \u89e3\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                log.error("----------> \u2705 \u89e3\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                throw throwable;
            }
        }
        long totalMillis = System.currentTimeMillis() - startTime;
        XxlJobHelper.log((String)"----------> \u2705 \u89e3\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
        log.error("----------> \u2705 \u89e3\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
    }

    public void processEncryptValueToTempBatch(NeedEncryptFieldParam fieldParam) {
        long totalCount;
        long startTime;
        AtomicReference<Object> lastProcessedIdRef;
        AtomicLong errorCount;
        AtomicLong skippedCount;
        AtomicLong processedCount;
        AtomicLong selectedCount;
        String columnName;
        String tableName;
        String schemaName;
        block6: {
            CryptoServiceImpl.judgeSchemaTableColumn(fieldParam);
            schemaName = fieldParam.getSchemaName();
            tableName = fieldParam.getTableName();
            columnName = fieldParam.getColumnName();
            selectedCount = new AtomicLong(0L);
            processedCount = new AtomicLong(0L);
            skippedCount = new AtomicLong(0L);
            errorCount = new AtomicLong(0L);
            lastProcessedIdRef = new AtomicReference<Object>(null);
            startTime = System.currentTimeMillis();
            List<Long> cidList = fieldParam.getHg() != null ? this.needEncryptFieldService.getHgCidList() : null;
            fieldParam.setCidList(cidList);
            fieldParam.setEncryptPrefix(PREFIX);
            totalCount = this.needEncryptFieldService.count(fieldParam);
            if (totalCount != 0L) break block6;
            fieldParam.setEncryptFlag(Boolean.TRUE);
            fieldParam.setDecryptFlag(Boolean.FALSE);
            this.needEncryptFieldService.putFlag(fieldParam);
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u8981\u52a0\u5bc6\u7684\u6570\u636e", (Object[])new Object[]{schemaName, tableName, columnName});
            log.error("\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u8981\u52a0\u5bc6\u7684\u6570\u636e", new Object[]{schemaName, tableName, columnName});
            this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
            long totalMillis = System.currentTimeMillis() - startTime;
            XxlJobHelper.log((String)"----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            log.error("----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
            return;
        }
        try {
            boolean hasMore;
            fieldParam.setTempPrefix("en_");
            this.needEncryptFieldService.createTempEncryptTable(fieldParam);
            while (hasMore = Boolean.TRUE.equals(this.transactionTemplate.execute(status -> {
                fieldParam.setLastPkValue((Long)lastProcessedIdRef.get());
                fieldParam.setLimit(MYSQL_BATCH_SIZE);
                ExecutorService innerExecutor = Executors.newFixedThreadPool(INNER_BATCH_SIZE);
                ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
                try {
                    long l1 = System.currentTimeMillis();
                    List<NeedEncryptFieldVo> mysqlRowList = this.needEncryptFieldService.batchSelectColumnValueList(fieldParam);
                    if (CollUtil.isEmpty(mysqlRowList)) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = System.currentTimeMillis();
                    List<List<NeedEncryptFieldVo>> dbPartitions = this.partitionList(mysqlRowList, INNER_BATCH_SIZE);
                    CountDownLatch esLatch = new CountDownLatch(dbPartitions.size());
                    ArrayList origiModelList = new ArrayList();
                    for (List<NeedEncryptFieldVo> partition : dbPartitions) {
                        innerExecutor.execute(() -> {
                            try {
                                List<String> partOriginalList = partition.stream().map(NeedEncryptFieldVo::getColumnValue).toList();
                                OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
                                partOriginalList = partOriginalList.stream().map(String::trim).map(s -> fieldParam.getNeedUpper() != false ? CharSequenceUtil.toUpperCase((CharSequence)s) : s).map(s -> EncryptUtils.encryptBySm4((String)s, (String)this.encryptContext.getPassword())).toList();
                                esParam.setOrgiDatas(partOriginalList);
                                PageInfo partPage = this.origiCipIdEsService.pageByPlaintextList(esParam, 1, BATCH_SIZE.intValue());
                                List partList = partPage == null || partPage.getList() == null ? Collections.emptyList() : partPage.getList();
                                origiModelList.addAll(partList);
                            }
                            catch (Exception e) {
                                log.error("\u67e5\u8be2es\u5f02\u5e38::", (Throwable)e);
                            }
                            finally {
                                esLatch.countDown();
                            }
                        });
                    }
                    try {
                        esLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    Map<String, OrigiCipIdModel> origiMap = origiModelList.stream().filter(m -> m != null && m.getOrgiData() != null).collect(Collectors.toMap(OrigiCipIdModel::getOrgiData, m -> m, (a, b) -> a));
                    ArrayList halfWayList = new ArrayList();
                    for (int i = 0; i < dbPartitions.size(); ++i) {
                        int batchIndex = i;
                        List<NeedEncryptFieldVo> list = dbPartitions.get(i);
                        if (CollUtil.isEmpty(list)) continue;
                        futures.add(innerExecutor.submit(() -> {
                            ArrayList<UpdateEncryptFieldDto> batchUpdateList = new ArrayList<UpdateEncryptFieldDto>();
                            for (NeedEncryptFieldVo row : rowList) {
                                Long pkValue = row.getPkValue();
                                String columnValue = row.getColumnValue();
                                try {
                                    String encryptedValue;
                                    String columnValueSM4;
                                    OrigiCipIdModel nowEsModel;
                                    if (!CharSequenceUtil.isNotBlank((CharSequence)columnValue) || columnValue.startsWith(PREFIX)) continue;
                                    if (fieldParam.getNeedUpper().booleanValue()) {
                                        columnValue = CharSequenceUtil.toUpperCase((CharSequence)columnValue);
                                    }
                                    if ((nowEsModel = (OrigiCipIdModel)origiMap.get(columnValueSM4 = EncryptUtils.encryptBySm4((String)columnValue, (String)this.encryptContext.getPassword()))) == null || nowEsModel.getCipData() == null) {
                                        encryptedValue = this.encryptorManager.encrypt(columnValue, this.encryptContext);
                                        OrigiCipIdModel m = new OrigiCipIdModel();
                                        m.setOrgiData(columnValueSM4);
                                        m.setCipData(columnValue);
                                        halfWayList.add(m);
                                    } else {
                                        encryptedValue = nowEsModel.getCipData();
                                    }
                                    UpdateEncryptFieldDto updateDto = new UpdateEncryptFieldDto(pkValue, encryptedValue);
                                    batchUpdateList.add(updateDto);
                                }
                                catch (Exception e) {
                                    errorCount.incrementAndGet();
                                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", (Object[])new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::PK/\u6570\u636e[{}/{}]::\u6b64\u6761\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff01\u5176\u4f59\u6570\u636e\u6b63\u5e38\u5904\u7406\u4e2d\u3002", new Object[]{schemaName, tableName, columnName, pkValue, columnValue, e});
                                }
                            }
                            return batchUpdateList;
                        }));
                    }
                    try {
                        if (CollUtil.isNotEmpty(halfWayList)) {
                            List halfWayPartitions = ListUtil.partition(halfWayList, (int)BATCH_SIZE);
                            for (List list : halfWayPartitions) {
                                this.origiCipIdEsService.batchSave(list);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("\u5b58es\u5f02\u5e38::", (Throwable)e);
                    }
                    ArrayList updateList = new ArrayList();
                    for (Future future : futures) {
                        try {
                            List batchResult = (List)future.get();
                            if (batchResult == null) continue;
                            updateList.addAll(batchResult);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            errorCount.incrementAndGet();
                            XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5e76\u884c\u52a0\u5bc6\u5904\u7406\u5931\u8d25", (Object[])new Object[]{schemaName, tableName, columnName, e});
                            log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u5e76\u884c\u52a0\u5bc6\u5904\u7406\u5931\u8d25", new Object[]{schemaName, tableName, columnName, e});
                        }
                    }
                    long l4 = System.currentTimeMillis();
                    long t1 = l2 - l1;
                    long t2 = l4 - l3;
                    long currentSelected = selectedCount.addAndGet(mysqlRowList.size());
                    long process = currentSelected * 100L / totalCount;
                    if (CollUtil.isNotEmpty(updateList)) {
                        long l5 = System.currentTimeMillis();
                        List updatePartitions = ListUtil.partition(updateList, (int)BATCH_SIZE);
                        CountDownLatch saveLatch = new CountDownLatch(updatePartitions.size());
                        for (List updatePartition : updatePartitions) {
                            innerExecutor.execute(() -> {
                                try {
                                    this.needEncryptFieldService.batchInsertToTempTable(updatePartition, fieldParam);
                                }
                                catch (Exception e) {
                                    log.error("\u63d2\u5165\u4e34\u65f6\u8868\u5f02\u5e38::", (Throwable)e);
                                }
                                finally {
                                    saveLatch.countDown();
                                }
                            });
                        }
                        try {
                            saveLatch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        long l6 = System.currentTimeMillis();
                        long currentProcessed = processedCount.addAndGet(updateList.size());
                        long t3 = l6 - l5;
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, t3, currentSelected, totalCount, process});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, t3, currentSelected, totalCount, process});
                    } else {
                        XxlJobHelper.log((String)"\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u52a0\u5bc6,\u65e0\u64cd\u4f5c::\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, currentSelected, totalCount, process});
                        log.error("\ud83d\udd35 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{},{}]::\u6279\u6b21({},+{}]\u5df2\u52a0\u5bc6,\u65e0\u64cd\u4f5c::\u52a0\u5bc6\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, 0L, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, currentSelected, totalCount, process});
                    }
                    lastProcessedIdRef.set(mysqlRowList.get(mysqlRowList.size() - 1).getPkValue());
                    Boolean bl = mysqlRowList.size() >= MYSQL_BATCH_SIZE;
                    return bl;
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    errorCount.incrementAndGet();
                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u6279\u6b21({},+{}]\u51fa\u9519::\u52a0\u5bc6\u5931\u8d25\uff01", (Object[])new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, e});
                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u6279\u6b21({},+{}]\u51fa\u9519::\u4e1a\u52a1\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff01", new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, e});
                    throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u52a0\u5bc6\u5931\u8d25", e);
                }
                finally {
                    CryptoServiceImpl.shutdown(innerExecutor);
                }
            }))) {
            }
            this.processEncryptValueToBusinessBatchNew_2step(fieldParam);
            fieldParam.setEncryptFlag(Boolean.TRUE);
            fieldParam.setDecryptFlag(Boolean.FALSE);
            this.needEncryptFieldService.putFlag(fieldParam);
            this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
        }
        catch (Exception e) {
            try {
                XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u52a0\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", (Object[])new Object[]{schemaName, tableName, columnName, e});
                log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u52a0\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", new Object[]{schemaName, tableName, columnName, e});
                throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u52a0\u5bc6\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u65ad", e);
            }
            catch (Throwable throwable) {
                this.needEncryptFieldService.dropTempEncryptTable(fieldParam);
                long totalMillis = System.currentTimeMillis() - startTime;
                XxlJobHelper.log((String)"----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                log.error("----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
                throw throwable;
            }
        }
        long totalMillis = System.currentTimeMillis() - startTime;
        XxlJobHelper.log((String)"----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", (Object[])new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
        log.error("----------> \u2705 \u52a0\u5bc6\u8f6c\u6362\u5b8c\u6bd5::[{}.{}.{}]::\u6210\u529f[{}]\u8df3\u8fc7[{}]\u5931\u8d25[{}]::\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{schemaName, tableName, columnName, processedCount.get(), skippedCount.get(), errorCount.get(), totalMillis});
    }

    private void processValueToBusiness(NeedEncryptFieldParam fieldParam) {
        String schemaName = fieldParam.getSchemaName();
        String tableName = fieldParam.getTableName();
        String columnName = fieldParam.getColumnName();
        long totalCount = this.needEncryptFieldService.countTemp(fieldParam);
        if (totalCount == 0L) {
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u4e34\u65f6\u8868\u65e0\u6570\u636e", (Object[])new Object[]{schemaName, tableName, columnName});
            log.error("\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u4e34\u65f6\u8868\u65e0\u6570\u636e", new Object[]{schemaName, tableName, columnName});
            return;
        }
        int totalBatches = (int)Math.ceil((double)totalCount / (double)TABLE_JOIN_BATCH_SIZE.intValue());
        AtomicLong processed = new AtomicLong(0L);
        fieldParam.setBatchSize(TABLE_JOIN_BATCH_SIZE);
        for (int batch = 0; batch < totalBatches; ++batch) {
            int offset = batch * TABLE_JOIN_BATCH_SIZE;
            fieldParam.setOffset(offset);
            long l1 = System.currentTimeMillis();
            int updatedCount = this.needEncryptFieldService.batchUpdateFromTempTable(fieldParam);
            long l2 = System.currentTimeMillis();
            long t = l2 - l1;
            processed.addAndGet(updatedCount);
            long progress = processed.get() * 100L / totalCount;
            XxlJobHelper.log((String)"\ud83d\udd04\u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{}]::\u8f6c\u6362\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t, processed, totalCount, progress});
            log.error("\ud83d\udd04\u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{}]::\u8f6c\u6362\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t, processed, totalCount, progress});
        }
    }

    public void processEncryptValueToBusinessBatchNew_2step(NeedEncryptFieldParam fieldParam) {
        CryptoServiceImpl.judgeSchemaTableColumn(fieldParam);
        String schemaName = fieldParam.getSchemaName();
        String tableName = fieldParam.getTableName();
        String columnName = fieldParam.getColumnName();
        AtomicLong selectedCount = new AtomicLong(0L);
        AtomicLong processedCount = new AtomicLong(0L);
        AtomicLong skippedCount = new AtomicLong(0L);
        AtomicLong errorCount = new AtomicLong(0L);
        AtomicReference<Object> lastProcessedIdRef = new AtomicReference<Object>(null);
        try {
            boolean hasMore;
            fieldParam.setEncryptPrefix(PREFIX);
            long totalCount = this.needEncryptFieldService.count(fieldParam);
            if (totalCount == 0L) {
                return;
            }
            while (hasMore = Boolean.TRUE.equals(this.transactionTemplate.execute(status -> {
                fieldParam.setLastPkValue((Long)lastProcessedIdRef.get());
                fieldParam.setLimit(MYSQL_BATCH_SIZE);
                ExecutorService innerExecutor = Executors.newFixedThreadPool(INNER_BATCH_SIZE);
                try {
                    long l1 = System.currentTimeMillis();
                    List<Long> tmpIdList = this.needEncryptFieldMapper.selectBatchPkValuesFromTempTable(fieldParam);
                    if (CollUtil.isEmpty(tmpIdList)) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = System.currentTimeMillis();
                    long currentSelected = selectedCount.addAndGet(tmpIdList.size());
                    if (CollUtil.isNotEmpty(tmpIdList)) {
                        List tempIdPartitions = ListUtil.partition(tmpIdList, (int)BATCH_SIZE);
                        CountDownLatch updateLatch = new CountDownLatch(tempIdPartitions.size());
                        for (List tempIdPartition : tempIdPartitions) {
                            innerExecutor.execute(() -> {
                                try {
                                    NeedEncryptFieldParam threadParam = new NeedEncryptFieldParam();
                                    BeanUtils.copyProperties((Object)fieldParam, (Object)threadParam);
                                    threadParam.setBatchPkValues(tempIdPartition);
                                    this.needEncryptFieldService.batchUpdateFromTempTableByPkValues(threadParam);
                                }
                                catch (Exception e) {
                                    log.error("\u66f4\u65b0\u4e1a\u52a1\u5f02\u5e38::", (Throwable)e);
                                }
                                finally {
                                    updateLatch.countDown();
                                }
                            });
                        }
                        try {
                            updateLatch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        long l4 = System.currentTimeMillis();
                        long t1 = l2 - l1;
                        long t2 = l4 - l3;
                        XxlJobHelper.log((String)"\ud83d\udd04 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{}]::\u8f6c\u6362\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, currentSelected, totalCount, currentSelected * 100L / totalCount});
                        log.error("\ud83d\udd04 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{}]::\u8f6c\u6362\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, currentSelected, totalCount, currentSelected * 100L / totalCount});
                    }
                    lastProcessedIdRef.set(tmpIdList.get(tmpIdList.size() - 1));
                    Boolean bl = tmpIdList.size() >= MYSQL_BATCH_SIZE;
                    return bl;
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    errorCount.incrementAndGet();
                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u8f6c\u6362\u5931\u8d25::\u6279\u6b21({},+{}]\u51fa\u9519", (Object[])new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, e});
                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u8f6c\u6362\u5931\u8d25::\u6279\u6b21({},+{}]\u51fa\u9519", new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, e});
                    throw new RuntimeException("\u8f6c\u6362\u5931\u8d25", e);
                }
                finally {
                    CryptoServiceImpl.shutdown(innerExecutor);
                }
            }))) {
            }
        }
        catch (Exception e) {
            XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", (Object[])new Object[]{schemaName, tableName, columnName, e});
            log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", new Object[]{schemaName, tableName, columnName, e});
            throw new RuntimeException("\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u65ad", e);
        }
    }

    public void processEncryptValueToBusinessBatchNew_1step(NeedEncryptFieldParam fieldParam) {
        CryptoServiceImpl.judgeSchemaTableColumn(fieldParam);
        String schemaName = fieldParam.getSchemaName();
        String tableName = fieldParam.getTableName();
        String columnName = fieldParam.getColumnName();
        AtomicLong selectedCount = new AtomicLong(0L);
        AtomicLong processedCount = new AtomicLong(0L);
        AtomicLong skippedCount = new AtomicLong(0L);
        AtomicLong errorCount = new AtomicLong(0L);
        AtomicReference<Object> lastProcessedIdRef = new AtomicReference<Object>(null);
        try {
            boolean hasMore;
            fieldParam.setEncryptPrefix(PREFIX);
            long totalCount = this.needEncryptFieldService.count(fieldParam);
            if (totalCount == 0L) {
                fieldParam.setEsEncrypt(Boolean.TRUE);
                this.needEncryptFieldService.putFlag(fieldParam);
                XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u52a0\u5bc6\u5b58\u5165ES\u7684\u6570\u636e", (Object[])new Object[]{schemaName, tableName, columnName});
                log.error("\u65e5\u5fd7\u6253\u5370::[{}.{}.{}]::\u6ca1\u6709\u9700\u52a0\u5bc6\u5b58\u5165ES\u7684\u6570\u636e", new Object[]{schemaName, tableName, columnName});
                return;
            }
            while (hasMore = Boolean.TRUE.equals(this.transactionTemplate.execute(status -> {
                fieldParam.setLastPkValue((Long)lastProcessedIdRef.get());
                fieldParam.setLimit(MYSQL_BATCH_SIZE);
                ExecutorService innerExecutor = Executors.newFixedThreadPool(INNER_BATCH_SIZE);
                try {
                    long l1 = System.currentTimeMillis();
                    NeedEncryptFieldVo temInf = this.needEncryptFieldMapper.selectNextPkFromTempTable(fieldParam);
                    if (temInf.getId() == null) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = System.currentTimeMillis();
                    long currentSelected = selectedCount.addAndGet(temInf.getTemBatchSize().intValue());
                    if (temInf.getHasFullBatchData().booleanValue()) {
                        try {
                            NeedEncryptFieldParam threadParam = new NeedEncryptFieldParam();
                            BeanUtils.copyProperties((Object)fieldParam, (Object)threadParam);
                            this.needEncryptFieldMapper.batchUpdateFromTempTableByPkValuesNew(threadParam);
                        }
                        catch (Exception e) {
                            log.error("\u66f4\u65b0\u4e1a\u52a1\u5f02\u5e38::", (Throwable)e);
                        }
                        long l4 = System.currentTimeMillis();
                        long t1 = l2 - l1;
                        long t2 = l4 - l3;
                        XxlJobHelper.log((String)"\ud83d\udd04 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{}]::\u8f6c\u6362\u8fdb\u5ea6[{}/{} {}%]", (Object[])new Object[]{schemaName, tableName, columnName, t1, t2, currentSelected, totalCount, currentSelected * 100L / totalCount});
                        log.error("\ud83d\udd04 \u8fdb\u5ea6::[{}.{}.{}]::\u8017\u65f6[{},{}]::\u8f6c\u6362\u8fdb\u5ea6[{}/{} {}%]", new Object[]{schemaName, tableName, columnName, t1, t2, currentSelected, totalCount, currentSelected * 100L / totalCount});
                    }
                    lastProcessedIdRef.set(temInf.getId());
                    Boolean bl = temInf.getTemBatchSize() >= MYSQL_BATCH_SIZE;
                    return bl;
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    errorCount.incrementAndGet();
                    XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u8f6c\u6362\u5931\u8d25::\u6279\u6b21({},+{}]\u51fa\u9519", (Object[])new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, e});
                    log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u8f6c\u6362\u5931\u8d25::\u6279\u6b21({},+{}]\u51fa\u9519", new Object[]{schemaName, tableName, columnName, fieldParam.getLastPkValue(), MYSQL_BATCH_SIZE, e});
                    throw new RuntimeException("\u8f6c\u6362\u5931\u8d25", e);
                }
                finally {
                    CryptoServiceImpl.shutdown(innerExecutor);
                }
            }))) {
            }
        }
        catch (Exception e) {
            XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", (Object[])new Object[]{schemaName, tableName, columnName, e});
            log.error("\u5f02\u5e38\u6253\u5370::[{}.{}.{}]::\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff01", new Object[]{schemaName, tableName, columnName, e});
            throw new RuntimeException("\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u65ad", e);
        }
    }

    private static void judgeSchemaTableColumn(NeedEncryptFieldParam fieldParam) {
        if (fieldParam.getSchemaName() == null || fieldParam.getTableName() == null || fieldParam.getColumnName() == null) {
            XxlJobHelper.log((String)"\u5f02\u5e38\u6253\u5370::\u5b57\u6bb5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1aschemaName\u3001tableName\u3001columnName", (Object[])new Object[0]);
            log.error("\u5f02\u5e38\u6253\u5370::\u5b57\u6bb5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1aschemaName\u3001tableName\u3001columnName");
            throw new IllegalArgumentException("\u5b57\u6bb5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private <T> List<List<T>> partitionList(List<T> list, int partitions) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int size = list.size();
        int batchSize = (int)Math.ceil((double)size / (double)partitions);
        for (int i = 0; i < partitions; ++i) {
            int fromIndex = i * batchSize;
            int toIndex = Math.min(fromIndex + batchSize, size);
            if (fromIndex < size) {
                result.add(list.subList(fromIndex, toIndex));
                continue;
            }
            result.add(new ArrayList());
        }
        return result;
    }

    private static void shutdown(ExecutorService executor) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void initEncryptContext() {
        this.encryptContext = new EncryptContext();
        this.encryptContext.setDataProcessingMethodsType(DataProcessingMethodsType.ACCURATE);
        this.encryptContext.setMiddlewareEnabled(this.fieldEncryptionProperties.getMiddlewareEnabled());
        this.encryptContext.setAlgorithm(AlgorithmType.getByName((String)this.fieldEncryptionProperties.getAlgorithm()));
        FieldEncryptorProperties.GroupConfig maxVersionGroupConfig = this.fieldEncryptionProperties.getMaxVersionGroupConfig();
        this.encryptContext.setVersion(maxVersionGroupConfig.getVersion());
        this.encryptContext.setPassword(maxVersionGroupConfig.getPassword());
        this.encryptContext.setPublicKey(maxVersionGroupConfig.getPublicKey());
        this.encryptContext.setPrivateKey(maxVersionGroupConfig.getPrivateKey());
    }

    public static Boolean endsWithX(String idCard) {
        if (idCard == null || idCard.isEmpty()) {
            return Boolean.FALSE;
        }
        char lastChar = (idCard = idCard.trim()).charAt(idCard.length() - 1);
        return (lastChar | 0x20) == 120;
    }

    public static boolean isAllDigits(String idCard) {
        if (idCard == null || idCard.isEmpty()) {
            return false;
        }
        for (int i = 0; i < idCard.length(); ++i) {
            if (Character.isDigit(idCard.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Generated
    public CryptoServiceImpl(TransactionTemplate transactionTemplate, ThreadPoolExecutor threadPoolExecutor, INeedEncryptFieldService needEncryptFieldService) {
        this.transactionTemplate = transactionTemplate;
        this.threadPoolExecutor = threadPoolExecutor;
        this.needEncryptFieldService = needEncryptFieldService;
    }

    private static class XxlJobLogRunnable
    implements Runnable {
        private final Runnable task;
        private final XxlJobContext jobContext;

        public XxlJobLogRunnable(Runnable task) {
            this.task = task;
            this.jobContext = XxlJobContext.getXxlJobContext();
        }

        @Override
        public void run() {
            if (this.jobContext != null) {
                XxlJobContext.setXxlJobContext((XxlJobContext)this.jobContext);
            }
            this.task.run();
        }
    }
}

